!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     titles of internal and external codes
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine titles_smash
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'SMASH - http://smash-qc.sourceforge.net/'
      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'SMASH: Scalable Molecular Analysis Solver for High' // &
     &   ' performance'
      write( 6, '(a)' ) &
     &   'computing systems, Version 2.2.0, written by K. Ishimura.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by S. Ruiz-Barragan, K. Ishimura,' // &
     &   ' M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'SMASH is an open-source software (Apache 2.0 license).'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_ntchem
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'NTCHEM - http://labs.aics.riken.jp/nakajimat_top' // &
     &   '/ntchem_j.html'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'T. Nakajima, M. Katouda, M. Kamiya, and Y. Nakatsuka,' // &
     &   ' Int. J. Quantum'
      write( 6, '(a)' ) &
     &   ' Chem. 115, 349–359 (2015).'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by Y. Kawashima, M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Acknowledgement to K. Sawada, T. Nakajima.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of NTCHEM license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any NTCHEM license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_g16
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) 'GAUSSIAN 16 - http://www.gaussian.com/'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'Gaussian 16, Revision B.01, M. J. Frisch, G.' &
     &   // ' W. Trucks, H. B. Schlegel, G.'
      write( 6, '(a)' ) 'E. Scuseria, M. A. Robb, J. R. Cheeseman, G.' &
     &   // ' Scalmani, V. Barone, G. A.'
      write( 6, '(a)' ) 'Petersson, H. Nakatsuji, X. Li, M. Caricato,' &
     &   // ' A. V. Marenich, J. Bloino, B.'
      write( 6, '(a)' ) 'G. Janesko, R. Gomperts, B. Mennucci, H. P.' &
     &   // ' Hratchian, J. V. Ortiz, A. F.'
      write( 6, '(a)' ) 'Izmaylov, J. L. Sonnenberg, D. Williams-Young,' &
     &   // ' F. Ding, F. Lipparini, F.'
      write( 6, '(a)' ) 'Egidi, J. Goings, B. Peng, A. Petrone, T.' &
     &   // ' Henderson, D. Ranasinghe, V. G.'
      write( 6, '(a)' ) 'Zakrzewski, J. Gao, N. Rega, G. Zheng, W.' &
     &   // ' Liang, M. Hada, M. Ehara, K.'
      write( 6, '(a)' ) 'Toyota, R. Fukuda, J. Hasegawa, M. Ishida,' &
     &   // ' T. Nakajima, Y. Honda, O. Kitao,'
      write( 6, '(a)' ) 'H. Nakai, T. Vreven, K. Throssell, J. A.' &
     &   // ' Montgomery, Jr., J. E. Peralta, F.'
      write( 6, '(a)' ) 'Ogliaro, M. J. Bearpark, J. J. Heyd, E. N.' &
     &   // ' Brothers, K. N. Kudin, V. N.'
      write( 6, '(a)' ) 'Staroverov, T. A. Keith, R. Kobayashi, J.' &
     &   // ' Normand, K. Raghavachari, A. P.'
      write( 6, '(a)' ) 'Rendell, J. C. Burant, S. S. Iyengar, J.' &
     &   // ' Tomasi, M. Cossi, J. M. Millam,'
      write( 6, '(a)' ) 'M. Klene, C. Adamo, R. Cammi, J. W. Ochterski,' &
     &   // ' R. L. Martin, K. Morokuma,'
      write( 6, '(a)' ) 'O. Farkas, J. B. Foresman, and D. J. Fox,' &
     &   // ' Gaussian, Inc., Wallingford CT,'
      write( 6, '(a)' ) '2016.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of GAUSSIAN license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any GAUSSIAN license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_g09
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) 'GAUSSIAN 09 - http://www.gaussian.com/'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'Gaussian 09, Revision D.01, M. J. Frisch,' // &
     &   ' G. W. Trucks, H. B. Schlegel, G.'
      write( 6, '(a)' ) 'E. Scuseria, M. A. Robb, J. R. Cheeseman,' // &
     &   ' G. Scalmani, V. Barone, B.'
      write( 6, '(a)' ) 'Mennucci, G. A. Petersson, H. Nakatsuji,' // &
     &   ' M. Caricato, X. Li, H. P.'
      write( 6, '(a)' ) 'Hratchian, A. F. Izmaylov, J. Bloino, G.' // &
     &   ' Zheng, J. L. Sonnenberg, M. Hada,'
      write( 6, '(a)' ) 'M. Ehara, K. Toyota, R. Fukuda, J.' // &
     &   ' Hasegawa, M. Ishida, T. Nakajima,'
      write( 6, '(a)' ) 'Y. Honda, O. Kitao, H. Nakai, T. Vreven,' // &
     &   ' J. A. Montgomery, Jr., J. E.'
      write( 6, '(a)' ) 'Peralta, F. Ogliaro, M. Bearpark, J. J.' // &
     &   ' Heyd, E. Brothers, K. N. Kudin, V.'
      write( 6, '(a)' ) 'N. Staroverov, R. Kobayashi, J. Normand,' // &
     &   ' K. Raghavachari, A. Rendell, J. C.'
      write( 6, '(a)' ) 'Burant, S. S. Iyengar, J. Tomasi, M.' // &
     &   ' Cossi, N. Rega, J. M. Millam, M. Klene,'
      write( 6, '(a)' ) 'J. E. Knox, J. B. Cross, V. Bakken, C.' // &
     &   ' Adamo, J. Jaramillo, R. Gomperts, R.'
      write( 6, '(a)' ) 'E. Stratmann, O. Yazyev, A. J. Austin,' // &
     &   ' R. Cammi, C. Pomelli, J. W.'
      write( 6, '(a)' ) 'Ochterski, R. L. Martin, K. Morokuma, V.' // &
     &   ' G. Zakrzewski, G. A. Voth, P.'
      write( 6, '(a)' ) 'Salvador, J. J. Dannenberg, S. Dapprich,' // &
     &   ' A. D. Daniels, Ö. Farkas, J. B.'
      write( 6, '(a)' ) 'Foresman, J. V. Ortiz, J. Cioslowski,' // &
     &   ' and D. J. Fox, Gaussian, Inc.,'
      write( 6, '(a)' ) 'Wallingford CT, 2009.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of GAUSSIAN license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any GAUSSIAN license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_g03
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'GAUSSIAN 03 - http://www.gaussian.com/'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'Gaussian 03, Revision C.02, M. J. Frisch,' // &
     &   ' G. W. Trucks, H. B. Schlegel, G.'
      write( 6, '(a)' ) 'E. Scuseria, M. A. Robb, J. R. Cheeseman,' // &
     &   ' J. A. Montgomery, Jr., T. Vreven,'
      write( 6, '(a)' ) 'K. N. Kudin, J. C. Burant, J. M. Millam,' // &
     &   ' S. S. Iyengar, J. Tomasi, V.'
      write( 6, '(a)' ) 'Barone, B. Mennucci, M. Cossi, G.' // &
     &   ' Scalmani, N. Rega, G. A. Petersson, H.'
      write( 6, '(a)' ) 'Nakatsuji, M. Hada, M. Ehara, K. Toyota,' // &
     &   ' R. Fukuda, J. Hasegawa, M. Ishida,'
      write( 6, '(a)' ) 'T. Nakajima, Y. Honda, O. Kitao, H.' // &
     &   ' Nakai, M. Klene, X. Li, J. E. Knox, H.'
      write( 6, '(a)' ) 'P. Hratchian, J. B. Cross, V. Bakken,' // &
     &   ' C. Adamo, J. Jaramillo, R. Gomperts,'
      write( 6, '(a)' ) 'R. E. Stratmann, O. Yazyev, A. J.' // &
     &   ' Austin, R. Cammi, C. Pomelli, J. W.'
      write( 6, '(a)' ) 'Ochterski, P. Y. Ayala, K. Morokuma, G.' // &
     &   ' A. Voth, P. Salvador, J. J.'
      write( 6, '(a)' ) 'Dannenberg, V. G. Zakrzewski, S.' // &
     &   ' Dapprich, A. D. Daniels, M. C. Strain, O.'
      write( 6, '(a)' ) 'Farkas, D. K. Malick, A. D. Rabuck, K.' // &
     &   ' Raghavachari, J. B. Foresman, J. V.'
      write( 6, '(a)' ) 'Ortiz, Q. Cui, A. G. Baboul, S.' // &
     &   ' Clifford, J. Cioslowski, B. B. Stefanov, G.'
      write( 6, '(a)' ) 'Liu, A. Liashenko, P. Piskorz, I.' // &
     &   ' Komaromi, R. L. Martin, D. J. Fox, T.'
      write( 6, '(a)' ) 'Keith, M. A. Al-Laham, C. Y. Peng, A.' // &
     &   ' Nanayakkara, M. Challacombe, P. M. W.'
      write( 6, '(a)' ) 'Gill, B. Johnson, W. Chen, M. W. Wong,' // &
     &   ' C. Gonzalez, and J. A. Pople,'
      write( 6, '(a)' ) 'Gaussian, Inc., Wallingford CT, 2004.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of GAUSSIAN license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any GAUSSIAN license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_g98
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) 'GAUSSIAN 98 - http://www.gaussian.com/'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'Gaussian 98 (Revision A.7), M. J. Frisch,' // &
     &   ' G. W. Trucks, H. B. Schlegel, G.'
      write( 6, '(a)' ) 'E. Scuseria, M. A. Robb, J. R. Cheeseman,' // &
     &   ' V. G. Zakrzewski, J. A.'
      write( 6, '(a)' ) 'Montgomery, R. E. Stratmann, J. C. Burant,' // &
     &   ' S. Dapprich, J. M. Millam, A. D.'
      write( 6, '(a)' ) 'Daniels, K. N. Kudin, M. C. Strain, O.' // &
     &   ' Farkas, J. Tomasi, V. Barone, M.'
      write( 6, '(a)' ) 'Cossi, R. Cammi, B. Mennucci, C. Pomelli,' // &
     &   ' C. Adamo, S. Clifford, J.'
      write( 6, '(a)' ) 'Ochterski, G. A. Petersson, P. Y. Ayala,' // &
     &   ' Q. Cui, K. Morokuma, D. K. Malick,'
      write( 6, '(a)' ) 'A. D. Rabuck, K. Raghavachari, J. B.' // &
     &   ' Foresman, J. Cioslowski, J. V. Ortiz,'
      write( 6, '(a)' ) 'B. B. Stefanov, G. Liu, A. Liashenko, P.' // &
     &   ' Piskorz, I. Komaromi, R. Gomperts,'
      write( 6, '(a)' ) 'R. L. Martin, D. J. Fox, , T. Keith, M.' // &
     &   ' A. Al-Laham, C. Y. Peng, A.'
      write( 6, '(a)' ) 'Nanayakkara, C. Gonzalez, M. Challacombe,' // &
     &   ' P. M. W. Gill, B. G. Johnson,'
      write( 6, '(a)' ) 'W. Chen, M. W. Wong, J. L. Andres, M.' // &
     &   ' Head-Gordon, E. S. Replogle, and J.'
      write( 6, '(a)' ) 'A. Pople, Gaussian, Inc., Pittsburgh, PA,' // &
     &   ' 1998.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of GAUSSIAN license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any GAUSSIAN license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_turbomole
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) 'TURBOMOLE - http://www.turbomole.com/'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'TURBOMOLE V6.2 2010, a developmet of' // &
     &   ' University of Kahlsruhe and'

      write( 6, '(a)' ) 'Forschungszentrum Kahlsruhe GmbH,' // &
     &   ' 1989-2007, TURBOMOLE GmbH, since 2007.'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'R. Ahlrichs, M. Bär, M. Häser, H. Horn,' // &
     &   ' C. Kölmel, "Electronic structure'
      write( 6, '(a)' ) 'calculations on workstation computers: The' // &
     &   ' program system turbomole." Chem.'
      write( 6, '(a)' ) 'Phys. Lett. 162, 165–169 (1989).'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of TURBOMOLE license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any TURBOMOLE license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_molpro
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'MOLPRO quantum chemistry package - http://www.molpro.net/'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'H.-J. Werner, P. J. Knowles, G. Knizia,' // &
     &   ' F. R. Manby, M. Schütz,'
      write( 6, '(a)' ) '"Molpro: a general purpose quantum' // &
     &    ' chemistry program package", WIREs'
      write( 6, '(a)' ) 'Comput. Mol. Sci., 2, 242-253 (2012).'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'MOLPRO, version 2012.1, H.-J. Werner, P.' // &
     &   ' J. Knowles, G. Knizia, F. R.'
      write( 6, '(a)' ) 'Manby, M. Schütz, P. Celani, T. Korona, R.' // &
     &   ' Lindh, A. Mitrushenkov, G.'
      write( 6, '(a)' ) 'Rauhut, K. R. Shamasundar, T. B. Adler, R.' // &
     &   ' D. Amos, A. Bernhardsson, A.'
      write( 6, '(a)' ) 'Berning, D. L. Cooper, M. J. O. Deegan, A.' // &
     &   ' J. Dobbyn, F. Eckert, E. Goll,'
      write( 6, '(a)' ) 'C. Hampel, A. Hesselmann, G. Hetzer, T.' // &
     &   ' Hrenar, G. Jansen, C. Köppl, Y.'
      write( 6, '(a)' ) 'Liu, A. W. Lloyd, R. A. Mata, A. J. May,' // &
     &   ' S. J. McNicholas, W. Meyer, M. E.'
      write( 6, '(a)' ) 'Mura, A. Nicklass, D. P. O' // "'" // &
     &   'Neill,' // ' P. Palmieri, D. Peng, K. Pflüger, R.'
      write( 6, '(a)' ) 'Pitzer, M. Reiher, T. Shiozaki, H. Stoll,' // &
     &   ' A. J. Stone, R. Tarroni, T.'
      write( 6, '(a)' ) 'Thorsteinsson, M. Wang.'

      write( 6, '(a)' ) 

      write( 6, '(a)' ) &
     &   'Interface code written by M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of MOLPRO license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any MOLPRO license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_orca
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'ORCA - An ab initio, DFT and semiempirical SCF-MO package -'

      write( 6, '(a)' ) &
     &   'https://orcaforum.cec.mpg.de/'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &  'F. Neese, F. Wennmohs, U. Becker, D. Bykov, D. Ganyushin,' // &
     &  ' A. Hansen,'
      write( 6, '(a)' ) &
     &  'R. Izsak, D. G. Liakos, C. Kollmar, S. Kossmann,' // &
     &  ' D. A. Pantazis, T. Petrenko,'

      write( 6, '(a)' ) &
     &  'C. Reimann, C. Riplinger, M. Roemelt, ' // &
     &  ' B. Sandhoefer, I. Schapiro,'

      write( 6, '(a)' ) &
     &  'K. Sivalingam, B. Wezisla, M. Kallay, S. Grimme, ' // &
     &  ' E. Valeev, G. Chan.'

      write( 6, '(a)' ) 

      write( 6, '(a)' ) &
     &   'Interface code written by M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of ORCA license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any ORCA license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_gamess
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'GAMESS - http://www.msg.chem.iastate.edu/gamess/'

      write( 6, '(a)' )

      write( 6, '(a)' ) '"General Atomic and Molecular Electronic' // &
     &   ' Structure System", M. W. Schmidt, K.'
      write( 6, '(a)' ) 'K. Baldridge, J. A. Boatz, S. T. Elbert,' // &
     &   ' M. S. Gordon, J. H. Jensen, S.'
      write( 6, '(a)' ) 'Koseki, N. Matsunaga, K. A. Nguyen, S. Su,' // &
     &   ' T. L. Windus, M. Dupuis, J. A.'
      write( 6, '(a)' ) 'Montgomery, J. Comput. Chem., 14,' // &
     &   ' 1347-1363 (1993).'

      write( 6, '(a)' )

      write( 6, '(a)' ) '"Advances in electronic structure theory:' // &
     &   ' GAMESS a decade later", M. S.'
      write( 6, '(a)' ) 'Gordon, M. W. Schmidt pp. 1167-1189, in' // &
     &   ' "Theory and Applications of'
      write( 6, '(a)' ) 'Computational Chemistry: the first forty' // &
     &   ' years", C. E. Dykstra, G. Frenking,'
      write( 6, '(a)' ) 'K. S. Kim, G. E. Scuseria (editors),' // &
     &   ' Elsevier, Amsterdam, 2005.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of GAMESS license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any GAMESS license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_mopac
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) 'MOPAC - http::/openmopac.net/'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'J. J. P. Stewart, "MOPAC: A General' // &
     &   ' Molecular Orbital Package." Quant. Chem.'
      write( 6, '(a)' ) &
     &   'Prog. Exch., 10, 86 (1990).'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'MOPAC2009, MOPAC2012, James J. P. Stewart,' // &
     &   ' Stewart Computational Chemistry,'
      write( 6, '(a)' ) 'Colorado Springs, CO, USA.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of MOPAC license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any MOPAC license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_abinit_mp
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'ABINIT-MP - http://moldb.nihs.go.jp/abinitmp/'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of ABINIT-MP license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any ABINIT-MP license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_vasp
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) 'The Vienna Ab initio Simulation Package' // &
     &   ' (VASP) - http://www.vasp.at/'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'G. Kresse and J. Hafner, "Ab initio' // &
     &   ' molecular dynamics for liquid metals",'
      write( 6, '(a)' ) 'Phys. Rev. B, 47, 558 (1993).'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'G. Kresse and J. Hafner, "Ab initio' // &
     &   ' molecular-dynamics simulation of the'
      write( 6, '(a)' ) 'liquid-metal-amorphous-semiconductor' // &
     &   ' transition in germanium", Phys. Rev. B,'
      write( 6, '(a)' ) '49, 14251 (1994).'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'G. Kresse and J. Furthmüller, "Efficiency' // &
     &   ' of ab-initio total energy'
      write( 6, '(a)' ) 'calculations for metals and semiconductors' // &
     &   ' using a plane-wave basis set",'
      write( 6, '(a)' ) 'Comput. Mat. Sci., 6, 15 (1996).'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'G. Kresse and J. Furthmüller, "Efficient' // &
     &   ' iterative schemes for ab initio'
      write( 6, '(a)' ) 'total-energy calculations using a' // &
     &   ' plane-wave basis set", Phys. Rev. B,'
      write( 6, '(a)' ) '54, 11169 (1996).'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of VASP license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any VASP license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_qe
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'Quantum Espresso:' // &
     &   ' http://dx.doi.org/10.1088/0953-8984/21/39/395502'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'P. Giannozzi, S. Baroni, N. Bonini, M. Calandra, R. Car,' // &
     &   ' C. Cavazzoni,'
      write( 6, '(a)' ) &
     &   'D. Ceresoli, G. L. Chiarotti, M. Cococcioni, I. Dabo,' // &
     &   ' A. Dal Corso, S. Fabris,'
      write( 6, '(a)' ) &
     &   'G. Fratesi, S. de Gironcoli, R. Gebauer, U. Gerstmann,' // &
     &   ' C. Gougoussis,'
      write( 6, '(a)' ) &
     &   'A. Kokalj, M. Lazzeri, L. Martin-Samos, N. Marzari,' // &
     &   ' F. Mauri, R. Mazzarello,'
      write( 6, '(a)' ) &
     &   'S. Paolini, A. Pasquarello, L. Paulatto, C. Sbraccia,' // &
     &   ' S. Scandolo,'
      write( 6, '(a)' ) &
     &   'G. Sclauzero, A. P. Seitsonen, A. Smogunov, P. Umari,' // &
     &   ' R. M. Wentzcovitch,'
      write( 6, '(a)' ) &
     &   'J. Phys.: Condens. Matter 21, 395502 (2009).'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of QE license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any QE license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_cp2k
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) 'CP2K - https://www.cp2k.org/'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'Interface code written by B. Thomsen.'
      
      write( 6, '(a)' ) 

      write( 6, '(a)' )  &
     & 'See the file cp2k_citations.out'  &
     & // ' for the citations used by your current calculation.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of CP2K license.'

      write( 6, '(a)' ) 'PIMD does not provide any CP2K license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_dftb
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) 'Density Functional based Tight Binding' // &
     &   ' (DFTB) - http://www.dftb.org/home/'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'D. Porezag, T. Frauenheim, T. Köhler, G.' // &
     &   ' Seifert, and R. Kaschner,'
      write( 6, '(a)' ) '"Construction of tight-binding-like' // &
     &   ' potentials on the basis of density-'
      write( 6, '(a)' ) 'functional theory: Application to carbon",' // &
     &   ' Phys. Rev. B 51, 12947 (1995).'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'G. Seifert, D. Porezag, and T. Frauenheim,' // &
     &   ' "Calculations of molecules,'
      write( 6, '(a)' ) 'clusters, and solids with a simplified' // &
     &   ' LCAO-DFT-LDA scheme", Int. J. Quantum'
      write( 6, '(a)' ) 'Chemistry 58, 185 (1996).'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'M. Elstner, D. Porezag, G. Jungnickel,' // &
     &   ' J. Elsner, M. Haugk, T. Frauenheim,'
      write( 6, '(a)' ) 'S. Suhai, and G. Seifert,' // &
     &   ' "Self-consistent-charge density-functional tight-'
      write( 6, '(a)' ) 'binding method for simulations of complex' // &
     &   ' materials properties", Phys. Rev.'
      write( 6, '(a)' ) 'B 58, 7260 (1998).'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of DFTB license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any DFTB license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_xtb
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) 'Semiempirical Extended Tight-Binding ' // &
     &   'Program Package (XTB)'

      write( 6, '(a)' ) 'https://github.com/grimme-lab/xtb'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'C. Bannwarth, E. Caldeweyher, S. Ehlert, A.' &
     &   // ' Hansen, P. Pracht, J. Seibert,'
      write( 6, '(a)' ) 'S. Spicher, S. Grimme WIREs Comput. Mol. Sci.,' &
     &   // ' 2020, 11, e01493.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by T. Murakami, '
      write( 6, '(a)' ) &
     &   'T. Takayanagi, M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of XTB license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any XTB license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_lbfgs
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) 'Limited memory BFGS - http://users.iems.' // &
     &   'northwestern.edu/~nocedal/lbfgs.html'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'J. Nocedal, "Updating Quasi-Newton Matrices' // &
     &   ' with Limited Storage",'
      write( 6, '(a)' ) 'Mathematics of Computation, 35,' // &
     &   ' 773-782 (1980).'

      write( 6, '(a)' )

      write( 6, '(a)' ) 'D. C. Liu and J. Nocedal, "On the Limited' // &
     &   ' Memory Method for Large Scale'
      write( 6, '(a)' ) 'Optimization", Mathematical Programming' // &
     &   ' B, 45, 3, 503-528 (1989).'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Modified code written by M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'LBFGS is an open-source software (Free BSD license).'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_alchem
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

!      write( 6, '(a)' )
!     &   'IMPORTANT: The user is solely responsible for all the'
!     &   // ' license issues of'
!      write( 6, '(a)' )
!     &   'external softwares used to compute hybrid potentials,'
!     &   // ' e.g.,'
!      write( 6, '(a)' )
!     &   'ABINIT-MP, DFTB, GAMESS, GAUSSIAN, MOLPRO, MOPAC, ORCA,'
!     &   // ' SMASH, TURBOMOLE.'
!      write( 6, '(a)' )
!     &   'PIMD does not provide any of these licenses.'
!
!      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_gad
!***********************************************************************

      write( 6, '(a)' ) &
     &   'GAD code is written by Y. Ota, M. Shiga.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_afed
!***********************************************************************

      write( 6, '(a)' ) &
     &   'AFED code is written by T. Morishita, M. Shiga.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_aenet
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'AENET - http://ann.atomistic.net/'
      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'AENET: The Atomic Energy NETwork package'

      write( 6, '(a)' ) &
     &   'written by N. Artrith (nartrith@atomistic.net).'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'N. Artrith and A. Urban, Comput. Mater. Sci. 114, 135-150' // &
     &   ' (2016).'
      write( 6, '(a)' ) &
     &   'N. Artrith, A. Urban, and G. Ceder, Phys. Rev. B 96,' // &
     &   ' 014112 (2017).'
      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by Y. Nagai and M. Shiga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Acknowledgement to K. Kobayashi.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_n2p2
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'N2P2 - https://compphysvienna.github.io/n2p2/'
      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'N2P2 - A neural network potential package'

      write( 6, '(a)' ) &
     &   'written by Andreas Singraber, University of Vienna, 2018.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Polynomial symmetry funcsions by Martin P. Bircher ' // &
     &   'and Andreas Singraber.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by B. Thomsen and M. Shiga.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_mtp
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'MLP - https://mlip.skoltech.ru/'
      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   "I.S. Novikov, K. Gubaev, E.V. Podryabinkin, A.V. Shapeev,"
      write( 6, '(a)' ) &
     &   "The MLIP package: Moment tensor potentials with mpi and" &
     &   // " active learning."
      write( 6, '(a)' ) &
     &   "Machine Learning: Science and Technology, 2, 025002 (2020)."
      write( 6, '(a)' ) &
     &   "(doi: 10.1088/2632-2153/abc9fe)"
      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   "A.V. Shapeev,"
      write( 6, '(a)' ) &
     &   "Moment tensor potentials: A class of systematically" &
     &   // " improvable interatomic"
      write( 6, '(a)' ) &
     &   "potentials,"
      write( 6, '(a)' ) &
     &   "Multiscale Modeling and Simulation, 14, 1153 (2016)."
      write( 6, '(a)' ) &
     &   "(doi: 10.1137/15M1054183)"
      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Adapted code written by H. Kwon and M. Shiga.'
      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_oss
!***********************************************************************

      write( 6, '(a)' ) &
     &   'L. Ojamae, I. Shavitt, S. J. Singer, J. Chem. Phys. 109,' // &
     &   ' 5547 (1998).'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_helium
!***********************************************************************

      write( 6, '(a)' ) &
     &   'R. A. Aziz, M. J. Slaman, J. Chem. Phys. 94, 8047 (1991).'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_hydrogen
!***********************************************************************

      write( 6, '(a)' ) &
     &   'I. F. Silvera, V. V. Goldman, J. Chem. Phys. 69, 4209 (1978).'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_phase0
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'PHASE/0: https://azuma.nims.go.jp/cms' // &
     &   '         Takahiro Yamasaki, Akiyoshi Kuroda, Toshihiro ' // &
     &   'Kato, Jun Nara,' // &
     &   '         Junichiro Koga, Tsuyoshi Uda, Kazuo Minami and' // &
     &   ' Takahisa Ohno,' // &
     &   '         Computer Physics Communications 244, 264 (2019).'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by J. Koga.'

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'IMPORTANT: The user is solely responsible for all the issues' &
     &   // ' of PHASE/0 license.'
      write( 6, '(a)' ) &
     &   'PIMD does not provide any PHASE/0 license.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_libnnp
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'LIBNNP - https://www.theochem.rub.de/go/rubnnet4md.html'
      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'developed at the Ruhr-Universitaet Bochum'
      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'J. Behler, M. Parrinello Phys. Rev. Lett., 98, 146401 (2007)'
      write( 6, '(a)' ) &
     &   'J. Behler, Angew. Chem. Int. Ed., 56, 12828 (2017)'
      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &    'LibNNP - A simple library for NNP in MD simulations'
      write( 6, '(a)' ) &
     &    'developed by F. Brieuc and C. Schran'
      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   'Interface code written by M. Shiga.'

      write( 6, '(a)' )

      return
      end





!***********************************************************************
      subroutine titles_gal
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'GAL21 - P. Clabaut, M. Beisert, C. Michel, S. N. Steinmann,'
      write( 6, '(a)' ) &
     &   'J. Chem. Phys. 157, 194705 (2022).'
      write( 6, '(a)' )

      return
      end

