!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     Tully surface hopping MD
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine tfscycle_MPI
!***********************************************************************

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   ab initio calculation   */
      call getforce_tfs_MPI

!     /*   hamiltonian   */
      call standard_tfs_MPI

!     /*   outer cycle:  time step = dt   */

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update cstate   */
         call update_cstate_MPI

!        /*   update nuclear momenta   */
         call update_vel_cart

!        /*   update nuclear positions   */
         call update_pos_cart

!        /*   ab initio calculation   */
         call getforce_tfs_MPI

!        /*   update nuclear momenta   */
         call update_vel_cart

!        /*   update cstate   */
         call update_cstate_MPI

!        /*   tully's fewest switch algorithm   */
         call hopping_tfs_MPI

!        /*   hamiltonian   */
         call standard_tfs_MPI

!        /*   do some analysis   */
         call analysis_tfs_MPI ( 2 )

!        /*   output restart   */
         call backup_tfs_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

      return
      end
