!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     Tully surface hopping MD
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine tfscycle
!***********************************************************************

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   ab initio calculation   */
      call getforce_tfs

!     /*   hamiltonian   */
      call standard_tfs

!     /*   do some analysis   */
      call analysis_tfs ( 1 )

!     /*   outer cycle:  time step = dt   */

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update cstate   */
         call update_cstate

!        /*   update nuclear momenta   */
         call update_vel_cart

!        /*   update nuclear positions   */
         call update_pos_cart

!        /*   ab initio calculation   */
         call getforce_tfs

!        /*   update nuclear momenta   */
         call update_vel_cart

!        /*   update cstate   */
         call update_cstate

!        /*   tully's fewest switch algorithm   */
         call hopping_tfs

!        /*   hamiltonian   */
         call standard_tfs

!        /*   do some analysis   */
         call analysis_tfs ( 2 )

!        /*   output restart   */
         call backup_tfs

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

      return
      end
