!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     compare analytical and numerical action
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine testforce_om
!***********************************************************************

      use common_variables, only : &
     &   x, y, z, ux, uy, uz, fdiff, natom, nbead

      use om_variables, only :  &
     &   fx_om, fy_om, fz_om, fux_om, fuy_om, fuz_om, action_om

      implicit none

      integer :: i, j

      integer :: ioption = 0

      real(8) :: ap, am, fa, ferr, a0

      real(8), dimension(natom,nbead) :: fx0, fy0, fz0

      real(8), dimension(natom,nbead) :: fux0, fuy0, fuz0

!-----------------------------------------------------------------------
!     //   action at the origin
!-----------------------------------------------------------------------

!     /*   convert position: normal modes to cartesian   */
      call nm_trans_om( 0 )

      call getaction_om

      call nm_trans_force_om( 1 )

      a0 = action_om

      fx0(:,:) = fx_om(:,:)
      fy0(:,:) = fy_om(:,:)
      fz0(:,:) = fz_om(:,:)

      fux0(:,:) = fux_om(:,:)
      fuy0(:,:) = fuy_om(:,:)
      fuz0(:,:) = fuz_om(:,:)

!-----------------------------------------------------------------------
!     //   test fx_om, fy_om, fz_om
!-----------------------------------------------------------------------

      if ( ( ioption .eq. 0 ) .or. ( ioption .eq. 1 ) ) then

      write( 6, '(a)' ) &
     &   '--------------------------------' // &
     &   '--------------------------------------------'
      write( 6, '(a)' ) &
     &   ' atom bead    force (analytical)' // &
     &   '     force (numerical)       difference (au)'
      write( 6, '(a)' ) &
     &   '--------------------------------' // &
     &   '--------------------------------------------'

      do j = 1, nbead
      do i = 1, natom

         x(i,j) = x(i,j) + fdiff
         call getaction_om
         ap = action_om

         x(i,j) = x(i,j) - 2.d0*fdiff
         call getaction_om
         am = action_om

         x(i,j) = x(i,j) + fdiff
         fa = - ( ap - am ) / (2.d0*fdiff)

         ferr = fx0(i,j) - fa

         write( 6, '(2i5,3f22.12)' ) i, j, fx0(i,j), fa, ferr

         y(i,j) = y(i,j) + fdiff
         call getaction_om
         ap = action_om

         y(i,j) = y(i,j) - 2.d0*fdiff
         call getaction_om
         am = action_om

         y(i,j) = y(i,j) + fdiff
         fa = - ( ap - am ) / (2.d0*fdiff)

         ferr = fy0(i,j) - fa

         write( 6, '(2i5,3f22.12)' ) i, j, fy0(i,j), fa, ferr

         z(i,j) = z(i,j) + fdiff
         call getaction_om
         ap = action_om

         z(i,j) = z(i,j) - 2.d0*fdiff
         call getaction_om
         am = action_om

         z(i,j) = z(i,j) + fdiff
         fa = - ( ap - am ) / (2.d0*fdiff)

         ferr = fz0(i,j) - fa

         write( 6, '(2i5,3f22.12)' )  i, j, fz0(i,j), fa, ferr

      end do
      end do

      end if

!-----------------------------------------------------------------------
!     //   test fux_om, fuy_om, fuz_om
!-----------------------------------------------------------------------

      if ( ( ioption .eq. 0 ) .or. ( ioption .eq. 2 ) ) then

      if ( ioption .eq. 0 ) write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   '--------------------------------' // &
     &   '--------------------------------------------'
      write( 6, '(a)' ) &
     &   ' atom bead  nmforce (analytical)' // &
     &   '   nmforce (numerical)       difference (au)'
      write( 6, '(a)' ) &
     &   '--------------------------------' // &
     &   '--------------------------------------------'

      do j = 1, nbead
      do i = 1, natom

         ux(i,j) = ux(i,j) + fdiff
         call nm_trans_om( 0 )
         call getaction_om
         call nm_trans_force_om( 1 )
         ap = action_om

         ux(i,j) = ux(i,j) - 2.d0*fdiff
         call nm_trans_om( 0 )
         call getaction_om
         call nm_trans_force_om( 1 )
         am = action_om

         ux(i,j) = ux(i,j) + fdiff
         call nm_trans_om( 0 )
         fa = - ( ap - am ) / (2.d0*fdiff)

         ferr = fux0(i,j) - fa

         write( 6, '(2i5,3f22.12)' ) i, j, fux0(i,j), fa, ferr

         uy(i,j) = uy(i,j) + fdiff
         call nm_trans_om( 0 )
         call getaction_om
         call nm_trans_force_om( 1 )
         ap = action_om

         uy(i,j) = uy(i,j) - 2.d0*fdiff
         call nm_trans_om( 0 )
         call getaction_om
         call nm_trans_force_om( 1 )
         am = action_om

         uy(i,j) = uy(i,j) + fdiff
         call nm_trans_om( 0 )
         fa = - ( ap - am ) / (2.d0*fdiff)

         ferr = fuy0(i,j) - fa

         write( 6, '(2i5,3f22.12)' ) i, j, fuy0(i,j), fa, ferr

         uz(i,j) = uz(i,j) + fdiff
         call nm_trans_om( 0 )
         call getaction_om
         call nm_trans_force_om( 1 )
         ap = action_om

         uz(i,j) = uz(i,j) - 2.d0*fdiff
         call nm_trans_om( 0 )
         call getaction_om
         call nm_trans_force_om( 1 )
         am = action_om

         uz(i,j) = uz(i,j) + fdiff
         call nm_trans_om( 0 )
         fa = - ( ap - am ) / (2.d0*fdiff)

         ferr = fuz0(i,j) - fa

         write( 6, '(2i5,3f22.12)' ) i, j, fuz0(i,j), fa, ferr

      end do
      end do

      end if

!-----------------------------------------------------------------------
!     //   reset at the origin
!-----------------------------------------------------------------------

      action_om = a0

      fx_om(:,:)  = fx0(:,:)
      fy_om(:,:)  = fy0(:,:)
      fz_om(:,:)  = fz0(:,:)

      fux_om(:,:) = fux0(:,:)
      fuy_om(:,:) = fuy0(:,:)
      fuz_om(:,:) = fuz0(:,:)

      return
      end
