!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     compare analytical and numerical forces
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine testforce
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fdiff, iounit_std, x, y, z, pot, fx, fy, fz, pux, puy, puz, &
     &   fux_ref, fuy_ref, fuz_ref, iexit, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i

      real(8), dimension(nbead) :: pot_m, pot_p

!-----------------------------------------------------------------------
!     /*   normal mode position -> Cartesian position                 */
!-----------------------------------------------------------------------

      call nm_trans( 0 )

!-----------------------------------------------------------------------
!     /*   force calculation                                          */
!-----------------------------------------------------------------------

      call getforce

!-----------------------------------------------------------------------
!     /*   save force                                                 */
!-----------------------------------------------------------------------

      fux_ref(:,:)  = fx(:,:) * dble(nbead)
      fuy_ref(:,:)  = fy(:,:) * dble(nbead)
      fuz_ref(:,:)  = fz(:,:) * dble(nbead)

!-----------------------------------------------------------------------
!     /*   start finite difference                                    */
!-----------------------------------------------------------------------

      do i = 1, natom

!-----------------------------------------------------------------------
!        /*   shift x                                                 */
!-----------------------------------------------------------------------

         x(i,:) = x(i,:) - fdiff

         call getforce

         pot_m(:)  = pot(:)

         x(i,:) = x(i,:) + 2.d0*fdiff

         call getforce

         pot_p(:)  = pot(:)

         x(i,:) = x(i,:) - fdiff

         pux(i,:)  = - ( pot_p(:) - pot_m(:) ) /(2.d0*fdiff)

!-----------------------------------------------------------------------
!        /*   shift y                                                 */
!-----------------------------------------------------------------------

         y(i,:) = y(i,:) - fdiff

         call getforce

         pot_m(:)  = pot(:)

         y(i,:) = y(i,:) + 2.d0*fdiff

         call getforce

         pot_p(:)  = pot(:)

         y(i,:) = y(i,:) - fdiff

         puy(i,:)  = - ( pot_p(:) - pot_m(:) ) /(2.d0*fdiff)

!-----------------------------------------------------------------------
!        /*   shift z                                                 */
!-----------------------------------------------------------------------

         z(i,:) = z(i,:) - fdiff

         call getforce

         pot_m  = pot(:)

         z(i,:) = z(i,:) + 2.d0*fdiff

         call getforce

         pot_p  = pot(:)

         z(i,:) = z(i,:) - fdiff

         puz(i,:)  = - ( pot_p(:) - pot_m(:) ) /(2.d0*fdiff)

!-----------------------------------------------------------------------

         call standard_testforce( i )

!-----------------------------------------------------------------------

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

!-----------------------------------------------------------------------

      end do

      return
      end

