!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     check existence of a file
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine testfile ( char_file, n, itest )
!***********************************************************************

      implicit none

      integer :: n, itest
      character(len=n) :: char_file
      logical :: lexist

      integer :: itrial
      integer :: ntrial = 5

      do itrial = 1, ntrial

         inquire ( file = char_file, exist = lexist )

         if ( lexist ) then
            itest = 0
            exit
         else
            itest = 1
         end if

      end do

      return
      end





!***********************************************************************
      subroutine testfile_old ( char_file, n, itest, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: n, itest, iounit, ierr

      character(len=n) :: char_file

      integer :: itrial
      integer :: ntrial = 5

      real(8) :: wait_time
      real(8) :: wait_time_min = 0.1d0

      character(len=8) :: char_time

!-----------------------------------------------------------------------
!     /*   check existence of file                                    */
!-----------------------------------------------------------------------

      call system ( 'test -e ' // char_file // ' ; echo $? > test.out' )

      open ( iounit, file = 'test.out' )
         read ( iounit, *, iostat=ierr ) itest
      close( iounit )

      call system ('rm -f test.out')

      if ( ierr .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   if read failed, try again with longer waiting periods      */
!-----------------------------------------------------------------------

      do itrial = 1, ntrial

         wait_time = wait_time_min * dble(2**(itrial-1))

         write( char_time, '(f8.1)' ) wait_time

         if ( ierr .ne. 0 ) then

         call system( 'sleep ' // char_time )

         call system('test -e ' // char_file // ' ; echo $? > test.out')

         call system( 'sleep ' // char_time )

         open ( iounit, file = 'test.out' )
            read ( iounit, *, iostat=ierr ) itest
         close( iounit )

         call system( 'sleep ' // char_time )

         call system( 'rm -f test.out' )

         end if

         if ( ierr .eq. 0 ) return

      end do

!-----------------------------------------------------------------------
!     /*   stop on error                                              */
!-----------------------------------------------------------------------

      if ( ierr .ne. 0 ) then

         write(6,'(a,a,a)') 'STOP:  error in reading ', char_file, '.'

         stop

      end if

!-----------------------------------------------------------------------

      return
      end
