!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Dec 18, 2020 by M. Shiga
!      Description:     testing ewald sum
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine testewald
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   potential, char_date

      use mm_variables, only : &
     &   eps_ewald, ratio_ewald, nbox_ewald, lmax_ewald

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: l

      real(8) :: eps_ewald_save, ratio_ewald_save

!-----------------------------------------------------------------------
!     /*   normal mode position -> Cartesian position                 */
!-----------------------------------------------------------------------

      call nm_trans(0)

!-----------------------------------------------------------------------
!     /*   print header                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' )
      write( 6,'(a)') &
     &   '====================================================' // &
     &   '=========================='

      write( 6, '(a)' ) &
     &   ' epsilon   ratio n1 n2 n3 l1 l2 l3     energy [au]  ' // &
     &   '           wall clock time'

      write( 6,'(a)') &
     &   '----------------------------------------------------' // &
     &   '--------------------------'

!     /*   wall clock time   */
      call getdate

      write( 6, '(52x,a26)' ) &
     &   char_date(1:26)

!     /*   calculate energy   */
      call getforce

!     /*   wall clock time   */
      call getdate

!     /*   print data   */
      write( 6, '(e8.1,f8.3,6i3,f16.9,2x,a26)' ) &
     &   eps_ewald, ratio_ewald, &
     &   nbox_ewald(1:3), lmax_ewald(1:3), &
     &   potential, char_date(1:26)

!-----------------------------------------------------------------------
!     /*   change eps_ewald                                           */
!-----------------------------------------------------------------------

!     /*   save ewald parameter   */
      eps_ewald_save = eps_ewald

!     //    different ewald parameters
      do l = 2, -2, -1

!        /*   change ewald parameter   */
         eps_ewald = eps_ewald_save * 10.d0**dble(l)

!        /*   reset ewald parameters   */
         call force_pol_ewald_reset

!        /*   calculate energy   */
         call getforce

!        /*   wall clock time   */
         call getdate

!        /*   print data   */
         write( 6, '(e8.1,f8.3,6i3,f16.9,2x,a26)' ) &
     &      eps_ewald, ratio_ewald, &
     &      nbox_ewald(1:3), lmax_ewald(1:3), &
     &      potential, char_date(1:26)

!     //    different ewald parameters
      end do

!     /*   restore ewald parameter   */
      eps_ewald = eps_ewald_save

!-----------------------------------------------------------------------
!     /*   change ratio_ewald                                         */
!-----------------------------------------------------------------------

!     /*   save ewald parameter   */
      ratio_ewald_save = ratio_ewald

!     //    different ewald parameters
      do l = -2, 2

!        /*   change ewald parameter   */
         ratio_ewald = ratio_ewald_save / 1.2d0**l

!        /*   reset ewald parameters   */
         call force_pol_ewald_reset

!        /*   calculate energy   */
         call getforce

!        /*   wall clock time   */
         call getdate

!        /*   print data   */
         write( 6, '(e8.1,f8.3,6i3,f16.9,2x,a26)' ) &
     &      eps_ewald, ratio_ewald, &
     &      nbox_ewald(1:3), lmax_ewald(1:3), &
     &      potential, char_date(1:26)

!     //    different ewald parameters
      end do

!     /*   restore ewald parameter   */
      ratio_ewald = ratio_ewald_save

      return
      end





!***********************************************************************
      subroutine testewpol
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   potential, char_date

      use mm_variables, only : &
     &   eps_ewpol, ratio_ewpol, nbox_ewpol, lmax_ewpol

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: l

      real(8) :: eps_ewpol_save, ratio_ewpol_save

!-----------------------------------------------------------------------
!     /*   normal mode position -> Cartesian position                 */
!-----------------------------------------------------------------------

      call nm_trans(0)

!-----------------------------------------------------------------------
!     /*   print header                                               */
!-----------------------------------------------------------------------

      write( 6, '(a)' )
      write( 6,'(a)') &
     &   '====================================================' // &
     &   '=========================='

      write( 6, '(a)' ) &
     &   ' epsilon   ratio n1 n2 n3 l1 l2 l3     energy [au]  ' // &
     &   '           wall clock time'

      write( 6,'(a)') &
     &   '----------------------------------------------------' // &
     &   '--------------------------'

!     /*   wall clock time   */
      call getdate

      write( 6, '(52x,a26)' ) &
     &   char_date(1:26)

!     /*   calculate energy   */
      call getforce

!     /*   wall clock time   */
      call getdate

!     /*   print data   */
      write( 6, '(e8.1,f8.3,6i3,f16.9,2x,a26)' ) &
     &   eps_ewpol, ratio_ewpol, &
     &   nbox_ewpol(1:3), lmax_ewpol(1:3), &
     &   potential, char_date(1:26)

!-----------------------------------------------------------------------
!     /*   change eps_ewpol                                           */
!-----------------------------------------------------------------------

!     /*   save ewald parameter   */
      eps_ewpol_save = eps_ewpol

!     //    different ewald parameters
      do l = 2, -2, -1

!        /*   change ewald parameter   */
         eps_ewpol = eps_ewpol_save * 10.d0**dble(l)

!        /*   reset ewald parameters   */
         call force_pol_ewald_reset

!        /*   calculate energy   */
         call getforce

!        /*   wall clock time   */
         call getdate

!        /*   print data   */
         write( 6, '(e8.1,f8.3,6i3,f16.9,2x,a26)' ) &
     &      eps_ewpol, ratio_ewpol, &
     &      nbox_ewpol(1:3), lmax_ewpol(1:3), &
     &      potential, char_date(1:26)

!     //    different ewald parameters
      end do

!     /*   restore ewald parameter   */
      eps_ewpol = eps_ewpol_save

!-----------------------------------------------------------------------
!     /*   change ratio_ewpol                                         */
!-----------------------------------------------------------------------

!     /*   save ewald parameter   */
      ratio_ewpol_save = ratio_ewpol

!     //    different ewald parameters
      do l = -2, 2

!        /*   change ewald parameter   */
         ratio_ewpol = ratio_ewpol_save / 1.2d0**l

!        /*   reset ewald parameters   */
         call force_pol_ewald_reset

!        /*   calculate energy   */
         call getforce

!        /*   wall clock time   */
         call getdate

!        /*   print data   */
         write( 6, '(e8.1,f8.3,6i3,f16.9,2x,a26)' ) &
     &      eps_ewpol, ratio_ewpol, &
     &      nbox_ewpol(1:3), lmax_ewpol(1:3), &
     &      potential, char_date(1:26)

!     //    different ewald parameters
      end do

!     /*   restore ewald parameter   */
      ratio_ewpol = ratio_ewpol_save

      return
      end





!***********************************************************************
      subroutine force_pol_ewald_reset
!***********************************************************************

      use common_variables, only : &
     &   pi, box, boxinv, volume, natom

      use mm_variables, only : &
     &   s_ewald, eps_ewald, ratio_ewald, alpha_ewald, rcut_ewald, &
     &   s_ewpol, eps_ewpol, ratio_ewpol, alpha_ewpol, rcut_ewpol, &
     &   lmax_ewald, nbox_ewald, lmax_ewpol, nbox_ewpol

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i

      real(8) :: snew, sold, sdif, absx, absy, absz, absa, absb, absc

!-----------------------------------------------------------------------
!     /*   parameter s:  solve exp(-s*s)/(s*s) = eps_ewald            */
!-----------------------------------------------------------------------

      snew = 0.d0

      do i = 1, 1000
         sold = snew
         snew = exp(-snew)*(snew+1.d0)/(eps_ewald+exp(-snew))
         sdif = abs(sold/snew - 1.d0)
         if ( sdif .lt. 1.d-15 ) exit
      end do

      s_ewald = sqrt(snew)

!-----------------------------------------------------------------------
!     /*   alpha:  exponent of fictitious Gaussian charge             */
!-----------------------------------------------------------------------

      alpha_ewald = (ratio_ewald*natom*pi**3/volume**2)**(1.d0/6.d0)

!-----------------------------------------------------------------------
!     /*   rcut:  cut off distance of real space sum                  */
!-----------------------------------------------------------------------

      rcut_ewald = s_ewald/alpha_ewald

!-----------------------------------------------------------------------
!     /*   lmax:  cut off in Fourier space sum                        */
!     /*          kmax = 2*pi/boxl*lmax                               */
!-----------------------------------------------------------------------

      absx = sqrt ( box(1,1)*box(1,1) &
     &            + box(2,1)*box(2,1) &
     &            + box(3,1)*box(3,1) )
      absy = sqrt ( box(1,2)*box(1,2) &
     &            + box(2,2)*box(2,2) &
     &            + box(3,2)*box(3,2) )
      absz = sqrt ( box(1,3)*box(1,3) &
     &            + box(2,3)*box(2,3) &
     &            + box(3,3)*box(3,3) )

      lmax_ewald(1) = int(s_ewald*absx*alpha_ewald/pi) + 1
      lmax_ewald(2) = int(s_ewald*absy*alpha_ewald/pi) + 1
      lmax_ewald(3) = int(s_ewald*absz*alpha_ewald/pi) + 1

!-----------------------------------------------------------------------
!     /*   extention of simulation box in real space sum              */
!-----------------------------------------------------------------------

      absa = sqrt ( boxinv(1,1)*boxinv(1,1) &
     &            + boxinv(1,2)*boxinv(1,2) &
     &            + boxinv(1,3)*boxinv(1,3) )
      absb = sqrt ( boxinv(2,1)*boxinv(2,1) &
     &            + boxinv(2,2)*boxinv(2,2) &
     &            + boxinv(2,3)*boxinv(2,3) )
      absc = sqrt ( boxinv(3,1)*boxinv(3,1) &
     &            + boxinv(3,2)*boxinv(3,2) &
     &            + boxinv(3,3)*boxinv(3,3) )

      nbox_ewald(1) = int(2.d0*rcut_ewald*absa) + 1
      nbox_ewald(2) = int(2.d0*rcut_ewald*absb) + 1
      nbox_ewald(3) = int(2.d0*rcut_ewald*absc) + 1

!-----------------------------------------------------------------------
!     /*   parameter s:  solve exp(-s*s)/(s*s) = eps_ewpol            */
!-----------------------------------------------------------------------

      snew = 0.d0

      do i = 1, 1000
         sold = snew
         snew = exp(-snew) * (snew + 1.d0) / (eps_ewpol + exp(-snew))
         sdif = abs( sold / snew - 1.d0 )
         if ( sdif .lt. 1.d-15 ) exit
      end do

      s_ewpol = sqrt(snew)

!-----------------------------------------------------------------------
!     /*   alpha:  exponent of fictitious Gaussian charge             */
!-----------------------------------------------------------------------

      alpha_ewpol = (ratio_ewpol*natom*pi**3/volume**2)**(1.d0/6.d0)

!-----------------------------------------------------------------------
!     /*   rcut:  cut off distance of real space sum                  */
!-----------------------------------------------------------------------

      rcut_ewpol = s_ewpol / alpha_ewpol

!-----------------------------------------------------------------------
!     /*   lmax:  cut off in Fourier space sum                        */
!     /*          kmax = 2*pi/boxl*lmax                               */
!-----------------------------------------------------------------------

      absx = sqrt ( box(1,1)*box(1,1) &
     &            + box(2,1)*box(2,1) &
     &            + box(3,1)*box(3,1) )
      absy = sqrt ( box(1,2)*box(1,2) &
     &            + box(2,2)*box(2,2) &
     &            + box(3,2)*box(3,2) )
      absz = sqrt ( box(1,3)*box(1,3) &
     &            + box(2,3)*box(2,3) &
     &            + box(3,3)*box(3,3) )

      lmax_ewpol(1) = int( s_ewpol * absx * alpha_ewpol / pi ) + 1
      lmax_ewpol(2) = int( s_ewpol * absy * alpha_ewpol / pi ) + 1
      lmax_ewpol(3) = int( s_ewpol * absz * alpha_ewpol / pi ) + 1

!-----------------------------------------------------------------------
!     /*   extention of simulation box in real space sum              */
!-----------------------------------------------------------------------

      absa = sqrt ( boxinv(1,1) * boxinv(1,1) &
     &            + boxinv(1,2) * boxinv(1,2) &
     &            + boxinv(1,3) * boxinv(1,3) )
      absb = sqrt ( boxinv(2,1) * boxinv(2,1) &
     &            + boxinv(2,2) * boxinv(2,2) &
     &            + boxinv(2,3) * boxinv(2,3) )
      absc = sqrt ( boxinv(3,1) * boxinv(3,1) &
     &            + boxinv(3,2) * boxinv(3,2) &
     &            + boxinv(3,3) * boxinv(3,3) )

      nbox_ewpol(1) = int( 2.d0 * rcut_ewpol * absa ) + 1
      nbox_ewpol(2) = int( 2.d0 * rcut_ewpol * absb ) + 1
      nbox_ewpol(3) = int( 2.d0 * rcut_ewpol * absc ) + 1

      return
      end
