!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     velocity scaling
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine temp_control
!***********************************************************************
!-----------------------------------------------------------------------
!
!     control the temperature by velocity scaling method
!
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   temp, ekin, boltz, temperature, vux, vuy, vuz, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      real(8) :: temp_scale

!-----------------------------------------------------------------------
!     /*   temp  =  instantaneous temperature                         */
!-----------------------------------------------------------------------

!     /*   calculate ekin =  fictitious kinetic energy   */
      call kinetic_energy

      temp = 2.d0*ekin/(3.d0*dble(natom*nbead))/boltz

      temp_scale = sqrt(temperature/temp)

!-----------------------------------------------------------------------
!     /*   scale the atomic velocity                                  */
!-----------------------------------------------------------------------

      do i = 1, nbead
      do j = 1, natom
         vux(j,i) = vux(j,i)*temp_scale
         vuy(j,i) = vuy(j,i)*temp_scale
         vuz(j,i) = vuz(j,i)*temp_scale
      end do
      end do

      return
      end
