!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     temperature accelerated sliced sampling
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine tasscycle
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref

      use tass_variables, only : dt_ref_tass, nref_tass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   initial setup                                              */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   ux --> x   */
      call nm_trans_cart( 2 )

!     /*   calculate physical potential   */
      call getforce

!     /*   fx --> fux   */
      call nm_trans_force_cart

!     /*   calculate gaussian potential   */
      call getforce_hills_tass

!     /*   calculate harmonic potential   */
      call getforce_ref_tass

!     /*   hamiltonian and temperature   */
      call standard_tass

!     /*   do some analysis   */
      call analysis_tass ( 1 )

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   add new gaussian   */
         call addhills_tass

!        /*   calculate gaussian potential   */
         call getforce_hills_tass

!        /*   calculate harmonic potential   */
         call getforce_ref_tass

!        /*   update system velocity: real potential    */
         call update_vel_sys_tass

         do iref = 1, nref_tass

!           /*   update thermostats attached to system   */
            call update_mnhc_sys_cart( dt_ref_tass )

!           /*   update cv velocity: gaussian potential   */
            call update_vel_cv_tass

!           /*   update thermostats attached to cv   */
            call update_mnhc_cv_tass

!           /*   update cv velocity: harmonic potential   */
            call update_vel_cv_ref_tass

!           /*   update system velocity: harmonic potential   */
            call update_vel_sys_ref_tass

!           /*   update system position   */
            call update_pos_sys_tass

!           /*   ux --> x   */
            call nm_trans_cart( 2 )

!           /*   update cv position   */
            call update_pos_cv_tass

!           /*   apply periodic boundary condition   */
            call pbc_cv_tass

!           /*   calculate harmonic potential   */
            call getforce_ref_tass

!           /*   update system velocity: harmonic potential   */
            call update_vel_sys_ref_tass

!           /*   update cv velocity: harmonic potential   */
            call update_vel_cv_ref_tass

!           /*   calculate gaussian potential   */
            call getforce_hills_tass

!           /*   update thermostats attached to cv   */
            call update_mnhc_cv_tass

!           /*   update cv velocity: gaussian potential   */
            call update_vel_cv_tass

!           /*   update thermostats attached to system   */
            call update_mnhc_sys_cart( dt_ref_tass )

         end do

!        /*   calculate physical potential   */
         call getforce

!        /*   fx --> fux   */
         call nm_trans_force_cart

!        /*   update system velocity: real potential    */
         call update_vel_sys_tass

!        /*   hamiltonian and temperature   */
         call standard_tass

!        /*   output restart   */
         call backup_tass

!        /*   do some analysis   */
         call analysis_tass ( 2 )

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end
