!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     Suzuki-Yoshida parameters
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine suzuki_yoshida
!***********************************************************************
!-----------------------------------------------------------------------
!
!     suzuki-yoshida parameters
!
!-----------------------------------------------------------------------

      use common_variables, only : ysweight, nys

      implicit none

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      integer :: j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      if ( nys .eq. 1 ) then
         ysweight(1)  = 1.d0
      else if ( nys .eq. 3 ) then
         ysweight(1)  = 1.d0/(2.d0 - 2.d0**(1.d0/3.d0))
         ysweight(2)  = 1.d0 - 2.d0*ysweight(1)
         ysweight(3)  = ysweight(1)
      else if ( nys .eq. 5 ) then
         ysweight(1)  = 1.d0/(4.d0 - 4.d0**(1.d0/3.d0))
         ysweight(2)  = ysweight(1)
         ysweight(3)  = 1.d0 - 4.d0*ysweight(1)
         ysweight(4)  = ysweight(1)
         ysweight(5)  = ysweight(1)
!      else if ( nys .eq. 7 ) then
!         ysweight(1)  =  0.784513610477560d0
!         ysweight(2)  =  0.235573213359357d0
!         ysweight(3)  = -1.177679984178870d0
!         ysweight(4)  =  1.d0 - 2.d0*( ysweight(1) + ysweight(2)
!     &                               + ysweight(3) )
!         ysweight(5)  = -1.177679984178870d0
!         ysweight(6)  =  0.235573213359357d0
!         ysweight(7)  =  0.784513610477560d0
!      else if ( nys .eq. 9 ) then
!         ysweight(1)  =  0.192000000000000d0
!         ysweight(2)  =  0.554910818409784d0
!         ysweight(3)  =  0.124659619941889d0
!         ysweight(4)  = -0.843182063596934d0
!         ysweight(5)  =  1.d0 - 2.d0*( ysweight(1) + ysweight(2)
!     &                               + ysweight(3) + ysweight(4) )
!         ysweight(6)  = -0.843182063596934d0
!         ysweight(7)  =  0.124659619941889d0
!         ysweight(8)  =  0.554910818409784d0
!         ysweight(9)  =  0.192000000000000d0
!      else if ( nys .eq. 15 ) then
!         ysweight(1)  =  0.914844246229740d0
!         ysweight(2)  =  0.253693336566229d0
!         ysweight(3)  = -1.444852236860480d0
!         ysweight(4)  = -0.158240635368243d0
!         ysweight(5)  =  1.938139137622760d0
!         ysweight(6)  = -1.960610232975490d0
!         ysweight(7)  =  0.102799849391985d0
!         ysweight(8)  =  1.d0 - 2.d0*( ysweight(1) + ysweight(2)
!     &                               + ysweight(3) + ysweight(4)
!     &                               + ysweight(5) + ysweight(6)
!     &                               + ysweight(7) )
!         ysweight(9)  =  0.102799849391985d0
!         ysweight(10) = -1.960610232975490d0
!         ysweight(11) =  1.938139137622760d0
!         ysweight(12) = -0.158240635368243d0
!         ysweight(13) = -1.444852236860480d0
!         ysweight(14) =  0.253693336566229d0
!         ysweight(15) =  0.914844246229740d0
      else
         do j = 1, nys
            ysweight(j) = 1.d0/dble(nys)
         end do
      end if

      return
      end

