!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jan 31, 2019 by M. Shiga
!      Description:     string method
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine stringcycle_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   variables                                                  */
!-----------------------------------------------------------------------

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit

!     /*   local variables   */
      implicit none

!-----------------------------------------------------------------------
!     /*   first cycle                                                */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   reorientation of the string   */
      call reorient_string_MPI

!     /*   align centroid   */
      call align_string

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   remove force for fixed atoms   */
      call update_force_string

!     /*   calculate force integral   */
      call getpot_string

!     /*   standard output   */
      call standard_string_MPI

!     /*   analysis   */
      call analysis_string_MPI( 1 )

!     /*   dt scaling   */
      call adapt_dt_string
      if ( iexit .eq. 1 ) return

!-----------------------------------------------------------------------
!     /*   loop of updates                                            */
!-----------------------------------------------------------------------

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update string   */
         call update_string

!        /*   reorientation of the string   */
         call reorient_string_MPI

!        /*   align string   */
         call align_string

!        /*   get interatomic forces   */
         call getforce_MPI

!        /*   remove force for fixed atoms   */
         call update_force_string

!        /*   calculate force integral   */
         call getpot_string

!        /*   standard output   */
         call standard_string_MPI

!        /*   do some analysis   */
         call analysis_string_MPI ( 2 )

!        /*   output restart   */
         call backup_string_MPI

!        /*   soft exit   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

!        /*   dt scaling   */
         call adapt_dt_string
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine update_force_string
!***********************************************************************
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fx, fy, fz, atom_change, natom

      implicit none

      integer :: j

!-----------------------------------------------------------------------

      do j = 1, natom

         if ( ( atom_change(j)(1:6) .eq. 'FREEZE' ) .or. &
     &        ( atom_change(j)(1:5) .eq. 'HEAVY'  ) .or. &
     &        ( atom_change(j)(1:6) .eq. 'FIXXYZ' ) ) then

            fx(j,:) = 0.d0
            fy(j,:) = 0.d0
            fz(j,:) = 0.d0

         else

            if      ( atom_change(j)(1:5) .eq. 'FIXX ' ) then
               fx(j,:) = 0.d0
            else if ( atom_change(j)(1:5) .eq. 'FIXXY' ) then
               fx(j,:) = 0.d0
            else if ( atom_change(j)(1:5) .eq. 'FIXXZ' ) then
               fx(j,:) = 0.d0
            end if

            if      ( atom_change(j)(1:5) .eq. 'FIXY ' ) then
               fy(j,:) = 0.d0
            else if ( atom_change(j)(1:5) .eq. 'FIXXY' ) then
               fy(j,:) = 0.d0
            else if ( atom_change(j)(1:5) .eq. 'FIXYZ' ) then
               fy(j,:) = 0.d0
            end if

            if      ( atom_change(j)(1:5) .eq. 'FIXZ ' ) then
               fz(j,:) = 0.d0
            else if ( atom_change(j)(1:5) .eq. 'FIXXZ' ) then
               fz(j,:) = 0.d0
            else if ( atom_change(j)(1:5) .eq. 'FIXYZ' ) then
               fz(j,:) = 0.d0
            end if

         end if

      end do

      return
      end
