!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 10, 2022 by M. Shiga
!      Description:     standard output of virial test
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine standard_testvirial_MPI( i, j, fbox_ref, fbox_fd )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : iounit_std, char_date, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      integer, save :: iset = 0

      real(8) :: fbox_ref(3,3)

      real(8) :: fbox_fd(3,3)

      real(8) :: small_value = 1.d-5

!-----------------------------------------------------------------------
!     /*   master process only                                        */
!-----------------------------------------------------------------------

      if ( myrank .ne. 0 ) return

!-----------------------------------------------------------------------
!     /*   test forces                                                */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         open ( iounit_std, file = 'standard.out', access = 'append' )

         write( iounit_std, '(a)' ) &
     &      '====================================================' // &
     &      '=========================='
         write( iounit_std, '(a)' ) &
     &      '     i     j  -dV/dH (analy)  -dV/dH (numer)  stat  ' // &
     &      'wall clock time           '
         write( iounit_std, '(a)' ) &
     &      '----------------------------------------------------' // &
     &      '--------------------------'

         close( iounit_std )

         write( 6, '(a)' ) &
     &      '====================================================' // &
     &      '=========================='
         write( 6, '(a)' ) &
     &      '     i     j  -dV/dH (analy)  -dV/dH (numer)  stat  ' // &
     &      'wall clock time           '
         write( 6, '(a)' ) &
     &      '----------------------------------------------------' // &
     &      '--------------------------'

         flush( 6 )

         iset = 1

      end if

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

!     /*   wall clock time   */
      call getdate

      open ( iounit_std, file = 'standard.out', access = 'append' )

      if ( abs(fbox_ref(i,j)-fbox_fd(i,j)) .lt. small_value ) then
         write(iounit_std,'(2i6,2f16.8,a6,2x,a26)') &
     &      i, j, fbox_ref(i,j), fbox_fd(i,j), 'OK', char_date
      else
         write(iounit_std,'(2i6,2f16.8,a6,2x,a26)') &
     &      i, j, fbox_ref(i,j), fbox_fd(i,j), ' X', char_date
      end if

      close( iounit_std )

      if ( abs(fbox_ref(i,j)-fbox_fd(i,j)) .lt. small_value ) then
         write(6,'(2i6,2f16.8,a6,2x,a26)') &
     &      i, j, fbox_ref(i,j), fbox_fd(i,j), 'OK', char_date
      else
         write(6,'(2i6,2f16.8,a6,2x,a26)') &
     &      i, j, fbox_ref(i,j), fbox_fd(i,j), ' X', char_date
      end if

      flush( 6 )

      return
      end
