!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jan 23, 2025 by M. Shiga
!      Description:     standard output of force test
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine standard_testforce_XMPI( i )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : pux, puy, puz, fux_ref, fuy_ref, &
     &   fuz_ref, iounit_std, char_date, myrank_main, myrank_sub, &
     &   nprocs_main

      use XMPI_variables, only : &
     &   jstart_bead, jend_bead, jstart_atom, jend_atom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k

      integer, save :: iset = 0

      real(8) :: fxan, fyan, fzan, fxfd, fyfd, fzfd

      real(8) :: small_value = 1.d-7

!-----------------------------------------------------------------------
!     /*   condition                                                  */
!-----------------------------------------------------------------------

      if ( ( i .lt. jstart_atom ) .or. ( i .gt. jend_atom ) ) return

!-----------------------------------------------------------------------
!     /*   test forces                                                */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         if ( ( myrank_main .eq. 0 ) .and. ( myrank_sub .eq. 0 ) ) then

         open ( iounit_std, file = 'standard.out', access = 'append' )

         write( iounit_std, '(a)' ) &
     &      '====================================================' // &
     &      '=========================='
         write( iounit_std, '(a)' ) &
     &      '  atom  bead  F (analytical)   F (numerical)  stat  ' // &
     &      'wall clock time           '
         write( iounit_std, '(a)' ) &
     &      '----------------------------------------------------' // &
     &      '--------------------------'

         close( iounit_std )

         write( 6, '(a)' ) &
     &      '====================================================' // &
     &      '=========================='
         write( 6, '(a)' ) &
     &      '  atom  bead  F (analytical)   F (numerical)  stat  ' // &
     &      'wall clock time           '
         write( 6, '(a)' ) &
     &      '----------------------------------------------------' // &
     &      '--------------------------'

         flush( 6 )

         end if

         iset = 1

      end if

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      do k = 1, nprocs_main

      if ( (k-1) .eq. myrank_main ) then

      do j = jstart_bead, jend_bead

         open ( iounit_std, file = 'standard.out', access = 'append' )

!        /*   wall clock time   */
         call getdate

         fxan = fux_ref(i,j)
         fyan = fuy_ref(i,j)
         fzan = fuz_ref(i,j)

         fxfd = pux(i,j)
         fyfd = puy(i,j)
         fzfd = puz(i,j)

         if ( abs(fxan-fxfd) .lt. small_value ) then
            write(6,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fxan, fxfd, 'OK', char_date
         else
            write(6,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fxan, fxfd, ' X', char_date
         end if

         if ( abs(fyan-fyfd) .lt. small_value ) then
            write(6,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fyan, fyfd, 'OK', char_date
         else
            write(6,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fyan, fyfd, ' X', char_date
         end if

         if ( abs(fzan-fzfd) .lt. small_value ) then
            write(6,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fzan, fzfd, 'OK', char_date
         else
            write(6,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fzan, fzfd, ' X', char_date
         end if

         if ( abs(fxan-fxfd) .lt. small_value ) then
            write(iounit_std,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fxan, fxfd, 'OK', char_date
         else
            write(iounit_std,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fxan, fxfd, ' X', char_date
         end if

         if ( abs(fyan-fyfd) .lt. small_value ) then
            write(iounit_std,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fyan, fyfd, 'OK', char_date
         else
            write(iounit_std,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fyan, fyfd, ' X', char_date
         end if

         if ( abs(fzan-fzfd) .lt. small_value ) then
            write(iounit_std,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fzan, fzfd, 'OK', char_date
         else
            write(iounit_std,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fzan, fzfd, ' X', char_date
         end if

         close( iounit_std )

         flush( 6 )

      end do

      end if

      call my_mpi_barrier_main ( )

      end do

!-----------------------------------------------------------------------

      return
      end
