!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 10, 2022 by M. Shiga
!      Description:     standard output of force test
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine standard_testforce_MPI( i )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : pux, puy, puz, fux_ref, fuy_ref, &
     &   fuz_ref, iounit_std, nbead, char_date, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      integer, save :: iset = 0

      real(8) :: fxan, fyan, fzan, fxfd, fyfd, fzfd

      real(8) :: small_value = 1.d-7

!-----------------------------------------------------------------------
!     /*   master process only                                        */
!-----------------------------------------------------------------------

      if ( myrank .ne. 0 ) return

!-----------------------------------------------------------------------
!     /*   test forces                                                */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         open ( iounit_std, file = 'standard.out', access = 'append' )

         write( iounit_std, '(a)' ) &
     &      '====================================================' // &
     &      '=========================='
         write( iounit_std, '(a)' ) &
     &      '  atom  bead  F (analytical)   F (numerical)  stat  ' // &
     &      'wall clock time           '
         write( iounit_std, '(a)' ) &
     &      '----------------------------------------------------' // &
     &      '--------------------------'

         close( iounit_std )

         write( 6, '(a)' ) &
     &      '====================================================' // &
     &      '=========================='
         write( 6, '(a)' ) &
     &      '  atom  bead  F (analytical)   F (numerical)  stat  ' // &
     &      'wall clock time           '
         write( 6, '(a)' ) &
     &      '----------------------------------------------------' // &
     &      '--------------------------'

         flush( 6 )

         iset = 1

      end if

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      open ( iounit_std, file = 'standard.out', access = 'append' )

      do j = 1, nbead

!        /*   wall clock time   */
         call getdate

         fxan = fux_ref(i,j)
         fyan = fuy_ref(i,j)
         fzan = fuz_ref(i,j)

         fxfd = pux(i,j)
         fyfd = puy(i,j)
         fzfd = puz(i,j)

         if ( abs(fxan-fxfd) .lt. small_value ) then
            write(6,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fxan, fxfd, 'OK', char_date
         else
            write(6,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fxan, fxfd, ' X', char_date
         end if

         if ( abs(fyan-fyfd) .lt. small_value ) then
            write(6,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fyan, fyfd, 'OK', char_date
         else
            write(6,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fyan, fyfd, ' X', char_date
         end if

         if ( abs(fzan-fzfd) .lt. small_value ) then
            write(6,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fzan, fzfd, 'OK', char_date
         else
            write(6,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fzan, fzfd, ' X', char_date
         end if

         if ( abs(fxan-fxfd) .lt. small_value ) then
            write(iounit_std,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fxan, fxfd, 'OK', char_date
         else
            write(iounit_std,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fxan, fxfd, ' X', char_date
         end if

         if ( abs(fyan-fyfd) .lt. small_value ) then
            write(iounit_std,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fyan, fyfd, 'OK', char_date
         else
            write(iounit_std,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fyan, fyfd, ' X', char_date
         end if

         if ( abs(fzan-fzfd) .lt. small_value ) then
            write(iounit_std,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fzan, fzfd, 'OK', char_date
         else
            write(iounit_std,'(2i6,2f16.10,a6,2x,a26)') &
     &         i, j, fzan, fzfd, ' X', char_date
         end if

      end do

      close( iounit_std )

      flush( 6 )

!-----------------------------------------------------------------------

      return
      end
