!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 10, 2022 by M. Shiga
!      Description:     standard output of tass
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine standard_tass_MPI
!***********************************************************************
!=======================================================================
!
!     calculate ``Hamiltonian'' and ``temperature'' in tass.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fictmass, vux, vuy, vuz, temp, boltz, gkt, qmass, vxbath, &
     &   vybath, vzbath, xbath, ybath, zbath, hamiltonian, potential, &
     &   iprint_std, natom, nbead, nnhc, ncolor

      use tass_variables, only : &
     &   fictmass_tass, vtass, ekin_tass, vbath_tass, rbath_tass, &
     &   ebath_tass, pot_ref_tass, potential_ref_tass, ekin_sys, &
     &   ebath_sys, potential_tass, qmass_tass, pot_tass, gkt_tass, &
     &   pot_lifted, ntass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, m

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      call standard_init_MPI( iset )

      if ( iprint_std .le. 0 ) return

!-----------------------------------------------------------------------
!     /*   kinetic energy                                             */
!-----------------------------------------------------------------------

      ekin_sys = 0.d0

      do j = 1, nbead
      do i = 1, natom
         ekin_sys = ekin_sys + 0.5d0*fictmass(i,j)*vux(i,j)*vux(i,j)
         ekin_sys = ekin_sys + 0.5d0*fictmass(i,j)*vuy(i,j)*vuy(i,j)
         ekin_sys = ekin_sys + 0.5d0*fictmass(i,j)*vuz(i,j)*vuz(i,j)
      end do
      end do

      temp = 2.d0*ekin_sys/dble(3*natom*nbead)/boltz

!-----------------------------------------------------------------------
!     /*   kinetic energy of collective variables                     */
!-----------------------------------------------------------------------

      ekin_tass = 0.d0

      do j = 1, nbead
      do i = 1, ntass
         ekin_tass = ekin_tass &
     &             + 0.5d0*fictmass_tass(i)*vtass(i,j)*vtass(i,j)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   ebath_sys  =  thermostats attached to system               */
!-----------------------------------------------------------------------

      ebath_sys = 0.d0

      do k = 1, nbead
         do j = 1, nnhc
         do i = 1, natom
            ebath_sys = ebath_sys &
     &           + 0.5d0*qmass(k)*vxbath(i,j,k)*vxbath(i,j,k) &
     &           + 0.5d0*qmass(k)*vybath(i,j,k)*vybath(i,j,k) &
     &           + 0.5d0*qmass(k)*vzbath(i,j,k)*vzbath(i,j,k) &
     &           + gkt*xbath(i,j,k) &
     &           + gkt*ybath(i,j,k) &
     &           + gkt*zbath(i,j,k)
         end do
         end do
      end do

!-----------------------------------------------------------------------
!     /*   ebath_tass  =  thermostats to collective variables         */
!-----------------------------------------------------------------------

      ebath_tass = 0.d0

      do k = 1, nbead
      do m = 1, ncolor
      do j = 1, nnhc
      do i = 1, ntass
         ebath_tass = ebath_tass &
     &   + 0.5d0*qmass_tass(m)*vbath_tass(i,j,m,k)*vbath_tass(i,j,m,k) &
     &   + gkt_tass*rbath_tass(i,j,m,k)
      end do
      end do
      end do
      end do

!-----------------------------------------------------------------------
!     /*   total energy                                               */
!-----------------------------------------------------------------------

      potential_tass = 0.d0

      do i = 1, nbead
         potential_tass = potential_tass + pot_tass(i)
      end do

      potential_ref_tass = 0.d0

      do i = 1, nbead
         potential_ref_tass = potential_ref_tass + pot_ref_tass(i)
      end do

!-----------------------------------------------------------------------
!     /*   total energy                                               */
!-----------------------------------------------------------------------

      hamiltonian = ekin_sys + potential + ekin_tass + potential_tass &
     &            + potential_ref_tass + ebath_sys + ebath_tass &
     &            - pot_lifted

!-----------------------------------------------------------------------
!     /*   output                                                     */
!-----------------------------------------------------------------------

      call standard_output_md_MPI

      return
      end
