!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 10, 2022 by M. Shiga
!      Description:     standard output of string method
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine standard_string
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   variables                                                  */
!-----------------------------------------------------------------------

!     /*   shared variables   */

      use common_variables, only : &
     &   pot, dt, istep, au_time, iounit_std, nbead, &
     &   char_date, iprint_std, iounit

      use string_variables, only : &
     &   pot_string_min, pot_string_mean

!     /*   local variables   */

      implicit none

      integer :: i, imax, imin

      real(8) :: pot_imax, pot_imin, dt_fs

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   standard output                                            */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         call read_int1 ( iprint_std, '<iprint_std>', 12, iounit )

         if ( istep .eq. 0 ) then

            open( iounit_std, file = 'standard.out', access = 'append' )

            write( iounit_std, '(a)' ) &
     &         '=============================' // &
     &         '================================================='

            write( iounit_std, '(a)' ) &
     &         '  step     dt    mean [au]     first  ' // &
     &         '    last   maximum  max  wall clock time'

            write( iounit_std, '(a)' ) &
     &         '-----------------------------' // &
     &         '-------------------------------------------------'

            close( iounit_std )

            write(          6, '(a)' ) &
     &         '=============================' // &
     &         '================================================='

            write(          6, '(a)' ) &
     &         '  step     dt    mean [au]     first  ' // &
     &         '    last   maximum  max  wall clock time'

            write(          6, '(a)' ) &
     &         '-----------------------------' // &
     &         '-------------------------------------------------'

            flush( 6 )

         else

            write(          6, '(a)' ) &
     &         '=============================' // &
     &         '================================================='

            write(          6, '(a)' ) &
     &         '  step     dt    mean [au]     first  ' // &
     &         '    last   maximum  max  wall clock time'

            write(          6, '(a)' ) &
     &         '-----------------------------' // &
     &         '-------------------------------------------------'

            flush( 6 )

         end if

         iset = 1

      end if

!-----------------------------------------------------------------------
!     /*   maximum and minimum potential values                       */
!-----------------------------------------------------------------------

      imax = 1
      imin = 1

      pot_imax = pot(1)
      pot_imin = pot(1)

      do i = 2, nbead

         if ( pot(i) .gt. pot_imax ) then
            imax = i
            pot_imax = pot(i)
         end if

         if ( pot(i) .lt. pot_imin ) then
            imin = i
            pot_imin = pot(i)
         end if

      end do

!-----------------------------------------------------------------------
!     /*   print standard output                                      */
!-----------------------------------------------------------------------

      if ( mod(istep,iprint_std) .eq. 0 ) then

         dt_fs = dt / (1.d-15/au_time)

         call getdate

         open( iounit_std, file = 'standard.out', access = 'append' )

!         write( iounit_std, '(i6,f6.3,3f13.5,1x,a26)' )
!     &      istep, dt_fs, pot(imax), pot(imin), potential, char_date

!         write( iounit_std, '(i6,f6.3,3f13.5,1x,a26)' )
!     &      istep, dt_fs, pot_string_max, pot_string_min,
!     &      pot_string_mean, char_date

         write( iounit_std, '(i6,f7.4,f13.5,3f10.5,i5,2x,a15)' ) &
     &      istep, dt_fs, pot_string_mean, pot(1)-pot_string_min, &
     &      pot(nbead)-pot_string_min, pot(imax)-pot_string_min, &
     &      imax, char_date(9:23)

         close( iounit_std )

         write(          6, '(i6,f7.4,f13.5,3f10.5,i5,2x,a15)' ) &
     &      istep, dt_fs, pot_string_mean, pot(1)-pot_string_min, &
     &      pot(nbead)-pot_string_min, pot(imax)-pot_string_min, &
     &      imax, char_date(9:23)

         flush( 6 )

      end if

      return
      end
