!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 10, 2022 by M. Shiga
!      Description:     standard output of steepest descent dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine standard_sd_MPI
!***********************************************************************
!=======================================================================
!
!     standard output for steepest descent.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   physmass, vx, vy, vz, ekin, natom, potential, hamiltonian, &
     &   hamiltonian_sys, char_date, boltz, temp, &
     &   istep, iprint_std, iounit, iounit_std, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, itest

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         call read_int1_MPI ( iprint_std, '<iprint_std>', 12, iounit )

         iset = 1

         if ( iprint_std .le. 0 ) return

         if ( myrank .ne. 0 ) return

         call testfile ( 'standard.out', 12, itest )

         if ( itest .eq. 1 ) then

            open( iounit_std, file = 'standard.out', access = 'append' )

            write( iounit_std, '(a)' ) &
     &      '==========================' // &
     &      '=========================='
            write( iounit_std, '(a)' ) &
     &      '    step  potential [au]  ' // &
     &      'wall clock time           '
            write( iounit_std, '(a)' ) &
     &      '--------------------------' // &
     &      '--------------------------'

            close( iounit_std )

            write( 6, '(a)' ) &
     &      '==========================' // &
     &      '=========================='
            write( 6, '(a)' ) &
     &      '    step  potential [au]  ' // &
     &      'wall clock time           '
            write( 6, '(a)' ) &
     &      '--------------------------' // &
     &      '--------------------------'

            flush( 6 )

         else

            write( 6, '(a)' ) &
     &      '==========================' // &
     &      '=========================='
            write( 6, '(a)' ) &
     &      '    step  potential [au]  ' // &
     &      'wall clock time           '
            write( 6, '(a)' ) &
     &      '--------------------------' // &
     &      '--------------------------'

            flush( 6 )

         end if

      end if

      if ( iprint_std .le. 0 ) return

!-----------------------------------------------------------------------
!     /*   temp  =  instantaneous temperature                         */
!-----------------------------------------------------------------------

!     /*   calculate ekin =  fictitious kinetic energy   */
      ekin = 0.d0

      do i = 1, natom
         ekin = ekin &
     &        + physmass(i)*vx(i,1)*vx(i,1) &
     &        + physmass(i)*vy(i,1)*vy(i,1) &
     &        + physmass(i)*vz(i,1)*vz(i,1)
      end do

      ekin = 0.5d0*ekin

      temp = 2.d0*ekin/dble(3*natom)/boltz

!-----------------------------------------------------------------------
!     /*   hamiltonian_sys  =  system Hamiltonian                     */
!-----------------------------------------------------------------------

      hamiltonian_sys = ekin + potential

!-----------------------------------------------------------------------
!     /*   hamiltonian =  total Hamiltonian                           */
!-----------------------------------------------------------------------

      hamiltonian = hamiltonian_sys

!-----------------------------------------------------------------------
!     /*   output                                                     */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then
      if ( mod(istep,iprint_std) .eq. 0 ) then

!        /*   wall clock time   */
         call getdate

!        /*   open file   */
         open( iounit_std, file = 'standard.out', access = 'append' )

!        /*   output   */
         write( iounit_std, '(i8,f16.8,2x,a28)' ) &
     &      istep, potential, char_date

!        /*   close file   */
         close( iounit_std )

         write( 6, '(i8,f16.8,2x,a28)' ) &
     &      istep, potential, char_date

!        /*   make sure output   */
         flush( 6 )

      end if
      end if

      return
      end

