!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 24, 2022 by M. Shiga
!      Description:     replica exchange Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine standard_remc_t_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   iprint_std, iounit_std, boltz, potential, &
     &   istep, istep_start, char_date, myrank

      use rehmc_variables, only : &
     &   ratio_mc_sub, ratio_mc

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      call standard_init_remc_MPI( iset )

      if ( iprint_std .le. 0 ) return

!-----------------------------------------------------------------------
!     /*   output                                                     */
!-----------------------------------------------------------------------

!     /*   parent rank only   */
      if ( myrank .ne. 0 ) return

!     /*   print interval   */
      if ( mod(istep,iprint_std) .eq. 0 ) then

!        /*   wall clock time   */
         call getdate

!        /*   if initial step   */
         if ( istep .eq. istep_start ) then

!           /*   open file    */
            open( iounit_std, file = 'standard.out', access = 'append' )

!           /*   output   */
            write( iounit_std, '(i8,9x,2a8,f18.8,2x,a26,1x)' ) &
     &         istep, ' -------',' -------', potential, char_date

!           /*   close file   */
            close( iounit_std )

!           /*   output   */
            write( 6, '(i8,9x,2a8,f18.8,2x,a26,1x)' ) &
     &         istep, ' -------',' -------', potential, char_date

!           /*   make sure output   */
            flush( 6 )

!        /*   if not initial step   */
         else

!           /*   open file    */
            open( iounit_std, file = 'standard.out', access = 'append' )

!           /*   output   */
            write( iounit_std, '(i8,9x,2f8.5,f18.8,2x,a26,1x)' ) &
     &         istep, ratio_mc, ratio_mc_sub, potential, char_date

!           /*   close file   */
            close( iounit_std )

!           /*   output   */
            write( 6, '(i8,9x,2f8.5,f18.8,2x,a26,1x)' ) &
     &         istep, ratio_mc, ratio_mc_sub, potential, char_date

!           /*   make sure output   */
            flush( 6 )

!        /*   end of if statement   */
         end if

!     /*   print interval   */
      end if

      return
      end





!***********************************************************************
      subroutine standard_remc_tx_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   iprint_std, iounit_std, boltz, potential, &
     &   istep, istep_start, char_date, myrank

      use rehmc_variables, only : &
     &   ratio_mc_sub, ratio_mc, ratio_rem

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      call standard_init_remc_MPI( iset )

      if ( iprint_std .le. 0 ) return

!-----------------------------------------------------------------------
!     /*   output                                                     */
!-----------------------------------------------------------------------

!     /*   parent rank only   */
      if ( myrank .ne. 0 ) return

!     /*   print interval   */
      if ( mod(istep,iprint_std) .eq. 0 ) then

!        /*   wall clock time   */
         call getdate

!        /*   if initial step   */
         if ( istep .eq. istep_start ) then

!           /*   open file    */
            open( iounit_std, file = 'standard.out', access = 'append' )

!           /*   output   */
            write( iounit_std, '(i8,1x,3a8,f18.8,2x,a26,1x)' ) &
     &         istep, ' -------', ' -------', ' -------', &
     &         potential, char_date

!           /*   close file   */
            close( iounit_std )

!           /*   output   */
            write( 6, '(i8,1x,3a8,f18.8,2x,a26,1x)' ) &
     &         istep, ' -------', ' -------', ' -------', &
     &         potential, char_date

!           /*   make sure output   */
            flush( 6 )

!        /*   if not initial step   */
         else

!           /*   open file    */
            open( iounit_std, file = 'standard.out', access = 'append' )

!           /*   output   */
            write( iounit_std, '(i8,1x,3f8.5,f18.8,2x,a26,1x)' ) &
     &         istep, ratio_rem, ratio_mc, ratio_mc_sub, &
     &         potential, char_date

!           /*   close file   */
            close( iounit_std )

!           /*   output   */
            write( 6, '(i8,1x,3f8.5,f18.8,2x,a26,1x)' ) &
     &         istep, ratio_rem, ratio_mc, ratio_mc_sub, &
     &         potential, char_date

!           /*   make sure output   */
            flush( 6 )

!        /*   end of if statement   */
         end if

!     /*   print interval   */
      end if

      return
      end





!***********************************************************************
      subroutine standard_init_remc_MPI( iset )
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   variables                                                  */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   iprint_std, iounit, iounit_std, method, myrank

      implicit none

      integer :: iset, itest

!-----------------------------------------------------------------------
!     /*   initialize output for remc                                 */
!-----------------------------------------------------------------------

      if ( ( iset .eq. 0 ) .and. ( method(1:5) .eq. 'REMC ' ) ) then

         call read_int1_MPI ( iprint_std, '<iprint_std>', 12, iounit )

         if ( iprint_std .le. 0 ) return

         if ( myrank .eq. 0 ) then

            call testfile ( 'standard.out', 12, itest )

            if ( itest .eq. 1 ) then

            open( iounit_std, file = 'standard.out', access = 'append' )

            write( iounit_std, '(a)' ) &
     &      '=====================================================' // &
     &      '========================='
            write( iounit_std, '(a)' ) &
     &      '    step   ratex   ratom    rasub    potential [au]  ' // &
     &      'wall clock time          '
            write( iounit_std, '(a)' ) &
     &      '-----------------------------------------------------' // &
     &      '-------------------------'

            close( iounit_std )

            write( 6, '(a)' ) &
     &      '=====================================================' // &
     &      '========================='
            write( 6, '(a)' ) &
     &      '    step   ratex   ratom    rasub    potential [au]  ' // &
     &      'wall clock time          '
            write( 6, '(a)' ) &
     &      '-----------------------------------------------------' // &
     &      '-------------------------'

            flush( 6 )

            else

            write( 6, '(a)' ) &
     &      '=====================================================' // &
     &      '========================='
            write( 6, '(a)' ) &
     &      '    step   ratex   ratom    rasub    potential [au]  ' // &
     &      'wall clock time          '
            write( 6, '(a)' ) &
     &      '-----------------------------------------------------' // &
     &      '-------------------------'

            flush( 6 )

            end if

         end if

         iset = 1

      end if

!-----------------------------------------------------------------------
!     /*   initialize output for remc                                 */
!-----------------------------------------------------------------------

      continue

      return
      end
