!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 24, 2022 by M. Shiga
!      Description:     output of replica exchange hybrid Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine standard_rehmc_t_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   iprint_std, iounit_std, myrank, boltz, dt, au_time, potential, &
     &   natom, nbead, istep, istep_start, char_date, myrank

      use rehmc_variables, only : &
     &   dt_fs, temp_bead, ekin_bead, ratio_hmc, ratio_rem

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i
      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      call standard_init_rehmc_MPI( iset )

      if ( iprint_std .le. 0 ) return

!-----------------------------------------------------------------------
!     /*   temp  =  instantaneous temperature                         */
!-----------------------------------------------------------------------

      do i = 1, nbead
         temp_bead(i) = 2.d0*ekin_bead(i)/dble(3*natom)/boltz
      end do

!-----------------------------------------------------------------------
!     /*   output                                                     */
!-----------------------------------------------------------------------

!     /*   master rank only   */
      if ( myrank .ne. 0 ) return

!     /*   print interval   */
      if ( mod(istep,iprint_std) .eq. 0 ) then

!        /*   wall clock time   */
         call getdate

!        /*   dt in fs   */
         dt_fs = dt / (1.d-15/au_time)

!        /*   if initial step   */
         if ( istep .eq. istep_start ) then

!           /*   open file    */
            open( iounit_std, file = 'standard.out', access = 'append' )

!           /*   output   */
            write( iounit_std, '(i8,f9.5,2a8,f18.8,2x,a26,1x)' ) &
     &         istep, dt_fs,' -------',' -------', potential, char_date

!           /*   close file    */
            close( iounit_std )

            write( 6, '(i8,f9.5,2a8,f18.8,2x,a26,1x)' ) &
     &         istep, dt_fs,' -------',' -------', potential, char_date

!           /*   make sure output   */
            flush( 6 )

!        /*   if not initial step   */
         else

!           /*   open file    */
            open( iounit_std, file = 'standard.out', access = 'append' )

!           /*   output   */
            write( iounit_std, '(i8,f9.5,2f8.5,f18.8,2x,a26,1x)' ) &
     &         istep, dt_fs, ratio_hmc, ratio_rem, potential, char_date

!           /*   close file    */
            close( iounit_std )

            write( 6, '(i8,f9.5,2f8.5,f18.8,2x,a26,1x)' ) &
     &         istep, dt_fs, ratio_hmc, ratio_rem, potential, char_date

!           /*   make sure output   */
            flush( 6 )

!        /*   end of if statement   */
         end if

!     /*   print interval   */
      end if

      return
      end





!***********************************************************************
      subroutine standard_rehmc_tx_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   iprint_std, iounit_std, myrank, boltz, dt, au_time, potential, &
     &   natom, nbead, istep, istep_start, char_date, myrank

      use rehmc_variables, only : &
     &   dt_fs, temp_bead, ekin_bead, ratio_hmc, ratio_rem

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i
      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      call standard_init_rehmc_MPI( iset )

      if ( iprint_std .le. 0 ) return

!-----------------------------------------------------------------------
!     /*   temp  =  instantaneous temperature                         */
!-----------------------------------------------------------------------

      do i = 1, nbead
         temp_bead(i) = 2.d0*ekin_bead(i)/dble(3*natom)/boltz
      end do

!-----------------------------------------------------------------------
!     /*   output                                                     */
!-----------------------------------------------------------------------

!     /*   master rank only   */
      if ( myrank .eq. 0 ) then

!     /*   print interval   */
      if ( mod(istep,iprint_std) .eq. 0 ) then

!        /*   wall clock time   */
         call getdate

!        /*   dt in fs   */
         dt_fs = dt / (1.d-15/au_time)

!        /*   if initial step   */
         if ( istep .eq. istep_start ) then

!           /*   open file    */
            open( iounit_std, file = 'standard.out', access = 'append' )

!           /*   output   */
            write( iounit_std, '(i8,f9.5,2a8,f18.8,2x,a26,1x)' ) &
     &         istep, dt_fs,' -------',' -------', potential, char_date

!           /*   close file    */
            close( iounit_std )

!           /*   output   */
            write( 6, '(i8,f9.5,2a8,f18.8,2x,a26,1x)' ) &
     &         istep, dt_fs,' -------',' -------', potential, char_date

!           /*   make sure output   */
            flush( 6 )

!        /*   if not initial step   */
         else

!           /*   open file    */
            open( iounit_std, file = 'standard.out', access = 'append' )

!           /*   output   */
            write( iounit_std, '(i8,f9.5,2f8.5,f18.8,2x,a26,1x)' ) &
     &         istep, dt_fs, ratio_hmc, ratio_rem, potential, char_date

!           /*   close file    */
            close( iounit_std )

!           /*   output   */
            write( 6, '(i8,f9.5,2f8.5,f18.8,2x,a26,1x)' ) &
     &         istep, dt_fs, ratio_hmc, ratio_rem, potential, char_date

!           /*   make sure output   */
            flush( 6 )

!        /*   end of if statement   */
         end if

!     /*   print interval   */
      end if

!     /*   master rank only   */
      end if

      return
      end





!***********************************************************************
      subroutine standard_rehmc_hx_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   iprint_std, iounit_std, myrank, boltz, dt, au_time, potential, &
     &   natom, nbead, istep, istep_start, char_date, myrank

      use rehmc_variables, only : &
     &   dt_fs, temp_bead, ekin_bead, ratio_hmc, ratio_rex

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i
      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      call standard_init_rehmc_MPI( iset )

      if ( iprint_std .le. 0 ) return

!-----------------------------------------------------------------------
!     /*   temp  =  instantaneous temperature                         */
!-----------------------------------------------------------------------

      do i = 1, nbead
         temp_bead(i) = 2.d0*ekin_bead(i)/dble(3*natom)/boltz
      end do

!-----------------------------------------------------------------------
!     /*   output                                                     */
!-----------------------------------------------------------------------

!     /*   master rank only   */
      if ( myrank .eq. 0 ) then

!     /*   print interval   */
      if ( mod(istep,iprint_std) .eq. 0 ) then

!        /*   wall clock time   */
         call getdate

!        /*   dt in fs   */
         dt_fs = dt / (1.d-15/au_time)

!        /*   if initial step   */
         if ( istep .eq. istep_start ) then

            open( iounit_std, file = 'standard.out', access = 'append' )

!           /*   output   */
            write( iounit_std, '(i8,f9.5,2a8,f18.8,2x,a26,1x)' ) &
     &         istep, dt_fs,' -------',' -------', potential, char_date

            close( iounit_std )

            write( 6, '(i8,f9.5,2a8,f18.8,2x,a26,1x)' ) &
     &         istep, dt_fs,' -------',' -------', potential, char_date

!           /*   make sure output   */
            flush( 6 )

!        /*   if not initial step   */
         else

            open( iounit_std, file = 'standard.out', access = 'append' )

!           /*   output   */
            write( iounit_std, '(i8,f9.5,2f8.5,f18.8,2x,a26,1x)' ) &
     &         istep, dt_fs, ratio_hmc, ratio_rex, potential, char_date

            close( iounit_std )

            write( 6, '(i8,f9.5,2f8.5,f18.8,2x,a26,1x)' ) &
     &         istep, dt_fs, ratio_hmc, ratio_rex, potential, char_date

!           /*   make sure output   */
            flush( 6 )

!        /*   end of if statement   */
         end if

!     /*   print interval   */
      end if

!     /*   master rank only   */
      end if

      return
      end





!***********************************************************************
      subroutine standard_init_rehmc_MPI( iset )
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   variables                                                  */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   iprint_std, iounit, iounit_std, myrank

      implicit none

      integer :: iset, itest

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         call read_int1_MPI ( iprint_std, '<iprint_std>', 12, iounit )

         if ( iprint_std .le. 0 ) return

         if ( myrank .eq. 0 ) then

            call testfile ( 'standard.out', 12, itest )

            if ( itest .eq. 1 ) then

            open( iounit_std, file = 'standard.out', access = 'append' )

            write( iounit_std, '(a)' ) &
     &      '=====================================================' // &
     &      '========================='
            write( iounit_std, '(a)' ) &
     &      '    step  dt [fs]   ratio   ratex    potential [au]  ' // &
     &      'wall clock time          '
            write( iounit_std, '(a)' ) &
     &      '-----------------------------------------------------' // &
     &      '-------------------------'

            close( iounit_std )

            write( 6, '(a)' ) &
     &      '=====================================================' // &
     &      '========================='
            write( 6, '(a)' ) &
     &      '    step  dt [fs]   ratio   ratex    potential [au]  ' // &
     &      'wall clock time          '
            write( 6, '(a)' ) &
     &      '-----------------------------------------------------' // &
     &      '-------------------------'

            flush( 6 )

            else

            write( 6, '(a)' ) &
     &      '=====================================================' // &
     &      '========================='
            write( 6, '(a)' ) &
     &      '    step  dt [fs]   ratio   ratex    potential [au]  ' // &
     &      'wall clock time          '
            write( 6, '(a)' ) &
     &      '-----------------------------------------------------' // &
     &      '-------------------------'

            flush( 6 )

            end if

         end if

         iset = 1

      end if

      return
      end

