!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 10, 2022 by M. Shiga
!      Description:     optimization of Onsager-Machlup action
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine standard_omopt
!***********************************************************************
!=======================================================================
!
!     calculate ``Hamiltonian'' and ``temperature''
!     no thermostat.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   pot, istep, istep_start, iprint_std, iounit_std, iounit, &
     &   nbead, char_date

      use om_variables, only : &
     &   action_all_om, action_om, action_ref_om

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, imax, imin

      real(8) :: pot_imax, pot_imin

      integer, save :: iset = 0

      integer :: itest

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         call read_int1 ( iprint_std, '<iprint_std>', 12, iounit )

         if ( iprint_std .le. 0 ) return

         call testfile ( 'standard.out', 12, itest, iounit )

         if ( itest .eq. 1 ) then

            open ( iounit_std, file='standard.out', access='append' )

            write( iounit_std, '(a)' ) &
     &      '====================================================' // &
     &      '=========================='
            write( iounit_std, '(a)' ) &
     &      '    step          S [au]       max  potential [au]  ' // &
     &      'wall clock time           '
            write( iounit_std, '(a)' ) &
     &      '----------------------------------------------------' // &
     &      '--------------------------'

            close( iounit_std )

            write( 6, '(a)' ) &
     &      '====================================================' // &
     &      '=========================='
            write( 6, '(a)') &
     &      '    step          S [au]       max  potential [au]  ' // &
     &      'wall clock time           '
            write( 6, '(a)' ) &
     &      '----------------------------------------------------' // &
     &      '--------------------------'

            flush( 6 )

         else

            write( 6, '(a)' ) &
     &      '====================================================' // &
     &      '=========================='
            write( 6, '(a)') &
     &      '    step          S [au]       max  potential [au]  ' // &
     &      'wall clock time           '
            write( 6, '(a)' ) &
     &      '----------------------------------------------------' // &
     &      '--------------------------'

            flush( 6 )

         end if

         iset = 1

      end if

      if ( iprint_std .le. 0 ) return

!-----------------------------------------------------------------------
!     /*   total action                                               */
!-----------------------------------------------------------------------

      action_all_om = action_om + action_ref_om

!-----------------------------------------------------------------------
!     /*   maximum and minimum potential values                       */
!-----------------------------------------------------------------------

      imax = 1
      imin = 1

      pot_imax = pot(1)
      pot_imin = pot(1)

      do i = 2, nbead

         if ( pot(i) .gt. pot_imax ) then
            imax = i
            pot_imax = pot(i)
         end if

         if ( pot(i) .lt. pot_imin ) then
            imin = i
            pot_imin = pot(i)
         end if

      end do

!-----------------------------------------------------------------------
!     /*   output                                                     */
!-----------------------------------------------------------------------

      if ( ( istep .eq. istep_start ) .or. &
     &     ( mod(istep,iprint_std) .eq. 0 ) ) then

!        /*   wall clock time   */
         call getdate

!        /*   open file   */
         open( iounit_std, file = 'standard.out', access = 'append' )

!        /*   output   */
         write( iounit_std, '(i8,f16.8,i10,f16.8,2x,a26)' ) &
     &      istep, action_all_om, imax, pot_imax, char_date

!        /*   close file   */
         close( iounit_std )

!        /*   output   */
         write( 6, '(i8,f16.8,i10,f16.8,2x,a26)' ) &
     &      istep, action_all_om, imax, pot_imax, char_date

!        /*   make sure output   */
         flush( 6 )

      end if

      return
      end
