!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 10, 2022 by M. Shiga
!      Description:     standard output of box optimization
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine standard_boxopt_MPI
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only: &
     &   iprint_std

      use lbfgs_variables, only : &
     &   pos, pos0, grad, frms, fmax, drms, dmax, ndim

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: k

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      call standard_init_opt_MPI( iset )

      if ( iprint_std .le. 0 ) return

!-----------------------------------------------------------------------
!     //   check convergence:  root-mean-square of residual force
!-----------------------------------------------------------------------

      frms = 0.d0

      do k = 1, ndim
         frms = frms + grad(k)*grad(k)
      end do

      frms = sqrt(frms)/ndim

!-----------------------------------------------------------------------
!     //   check convergence:  maximum value of residual force
!-----------------------------------------------------------------------

      fmax = 0.d0

      do k = 1, ndim
         fmax = max ( abs( grad(k) ), fmax )
      end do

!-----------------------------------------------------------------------
!     //   check convergence:  root-mean-square of geometrical shift
!-----------------------------------------------------------------------

      drms = 0.d0

      do k = 1, ndim
         drms = drms + (pos(k)-pos0(k))*(pos(k)-pos0(k))
      end do

      drms = sqrt(drms)/ndim

!-----------------------------------------------------------------------
!     //   check convergence:  maximum value of geometrical shift
!-----------------------------------------------------------------------

      dmax = 0.d0

      do k = 1, ndim
         dmax = max ( abs( pos(k)-pos0(k) ), dmax )
      end do

!-----------------------------------------------------------------------
!     //   output
!-----------------------------------------------------------------------

      call standard_output_opt_MPI

      return
      end
