!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga, H. Kimizuka
!      Last updated:    Jan 8, 2019 by M. Shiga
!      Description:     spline intrapolation of string
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      pure function spline_string_func( xa, ya, y2a, x, k ) result(y)
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integers   */
      integer, intent(in) :: k

!     /*   real values   */
      real(8), intent(in) :: xa(:), ya(:), y2a(:)
      real(8), intent(in) :: x
      real(8) :: h, a, b, y

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      h = xa(k+1)-xa(k)

      a = (xa(k+1)-x)/h
      b = 1.d0 - a

      y = a*ya(k)+b*ya(k+1) &
     &  + ((a*a*a-a)*y2a(k)+(b*b*b-b)*y2a(k+1))*(h*h)/6.d0

      return
      end function spline_string_func
