!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga, H. Kimizuka
!      Last updated:    Jan 9, 2018 by M. Shiga
!      Description:     spline intrapolation of string
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      pure function spline_locate_func( xa, n, x ) result(klo)
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integers   */
      integer, intent(in) :: n
      integer :: klo, khi, k

!     /*   real values   */
      real(8), intent(in) :: xa(:)
      real(8), intent(in) :: x

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      if ( x .lt. xa(1) ) then

         klo = 1
         khi = 2

      else if ( x .gt. xa(n) ) then

         klo = n-1
         khi = n

      else

         klo = 1
         khi = n

         do while ( khi-klo .gt. 1 )

            k = (khi+klo)/2
            if ( xa(k) .gt. x ) then
               khi = k
            else
               klo = k
            end if

         end do

      end if

      return
      end function spline_locate_func

