!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     routine for soft exit
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine softexit
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   iread_exit, istep, iexit, iounit, nstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: itest

!-----------------------------------------------------------------------
!     /*   only at intervals iread_exit                               */
!-----------------------------------------------------------------------

      if ( iread_exit .le. 0 ) then
         return
      else if ( istep .eq. nstep ) then
         continue
      else if ( mod(istep,iread_exit) .ne. 0 ) then
         return
      end if

!-----------------------------------------------------------------------
!     /*   iexit = 0, default is not to exit                          */
!-----------------------------------------------------------------------

      iexit = 0

!-----------------------------------------------------------------------
!     /*   check if file called `exit.dat' exists                     */
!-----------------------------------------------------------------------

      call testfile ( 'exit.dat', 8, itest, iounit )

!-----------------------------------------------------------------------
!     /*   if the file exists,                                        */
!-----------------------------------------------------------------------

      if ( itest .eq. 0 ) then

!        /*   signal for exit   */
         iexit = 1

!        /*   remove file `exit.dat'   */
         call system ('rm -f exit.dat')

      end if

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( iexit .eq. 1 ) then

         write( 6, '(a)' )
         write( 6, '(a)' ) &
     &      'TERMINATED BY USER: file exit.dat detected.'
         write( 6, '(a)' )

      end if

      return
      end

