!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     set up force test
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setup_testforce_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : fdiff, iounit, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ierr

      character(len=80) :: char_line

!-----------------------------------------------------------------------
!     /*   finite difference parameter                                */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

         ierr = 0

         open ( iounit, file = 'input.dat' )
         do
            read ( iounit, *, iostat=ierr )  char_line
            if ( char_line(1:7) .eq. '<fdiff>' ) then
               read( iounit, *, iostat=ierr ) fdiff
               exit
            end if
            if ( ierr .ne. 0 ) exit
         end do
         close( iounit )

         if ( ierr .ne. 0 )  then
         open ( iounit, file = 'input_default.dat' )
            do
               read ( iounit, *, iostat=ierr )  char_line
               if ( char_line(1:7) .eq. '<fdiff>' ) then
                  read( iounit, *, iostat=ierr ) fdiff
                  exit
               end if
               if ( ierr .ne. 0 ) exit
            end do
         close( iounit )
         end if

      end if

      call my_mpi_bcast_int_0 ( ierr )

      if ( myrank .eq. 0 ) then
         if ( ierr .ne. 0 ) then
            write( 6, '(a)' ) 'Error - <fdiff> read incorrectly.'
            write( 6, '(a)' )
         end if
      end if

      call error_handling_MPI &
     &   ( ierr, 'subroutine setup_testforce_MPI', 30 )

      call my_mpi_bcast_real_0 ( fdiff )

!-----------------------------------------------------------------------
!     /*   read geometry                                              */
!-----------------------------------------------------------------------

      call setup_geometry_MPI

      return
      end
