!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     set up force test
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setup_testforce
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : fdiff, iounit

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ierr

      character(len=80) :: char_line

!-----------------------------------------------------------------------
!     /*   finite difference parameter                                */
!-----------------------------------------------------------------------

      ierr = 0

      open ( iounit, file = 'input.dat' )
         do
            read ( iounit, *, iostat=ierr )  char_line
            if ( char_line(1:7) .eq. '<fdiff>' ) then
               read( iounit, *, iostat=ierr ) fdiff
               exit
            end if
            if ( ierr .ne. 0 ) exit
         end do
      close( iounit )

      if ( ierr .ne. 0 )  then
         open ( iounit, file = 'input_default.dat' )
            do
               read ( iounit, *, iostat=ierr )  char_line
               if ( char_line(1:7) .eq. '<fdiff>' ) then
                  read( iounit, *, iostat=ierr ) fdiff
                  exit
               end if
               if ( ierr .ne. 0 ) exit
            end do
         close( iounit )
      end if

      if ( ierr .ne. 0 ) then
         write( 6, '(a)' ) 'Error - <fdiff> read incorrectly.'
         write( 6, '(a)' )
      end if

      call error_handling ( ierr, 'subroutine setup_testforce', 26 )

!-----------------------------------------------------------------------
!     /*   read geometry                                              */
!-----------------------------------------------------------------------

      call setup_geometry

      return
      end
