!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 17, 2022 by M. Shiga
!      Description:     set up string method
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setup_string
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   variables                                                  */
!-----------------------------------------------------------------------

!     /*   shared variables   */

      use common_variables, only : &
     &    dt, natom, nbead, iounit, ipos_start

      use string_variables, only : &
     &    pot_string, s_ref, r1_ref, r2_ref, f1_ref, f2_ref, arc_ref, &
     &    s1_ref, s2_ref, dtmax_string, rc_arc, pot_arc, pot1_ref, &
     &    pot2_ref, ngrid_string, narc, auto_string

      use string_variables, only : &
     &    xmax_string, ymax_string, zmax_string, dmax_string

!     /*   local variables   */
      implicit none

!-----------------------------------------------------------------------
!     /*   read parameters                                            */
!-----------------------------------------------------------------------

!     /*   arc length grids per nbead  */
      call read_int1( ngrid_string, '<ngrid_string>', 14, iounit )

!-----------------------------------------------------------------------
!     /*   read parameters                                            */
!-----------------------------------------------------------------------

!     /*   automatic control of dt   */
      call read_char( auto_string, 4, '<auto_string>', 13, iounit )

!-----------------------------------------------------------------------
!     /*   constants                                                  */
!-----------------------------------------------------------------------

!     /*   total number of arc length grids   */
      narc = (ngrid_string-1)*(nbead-1) + 1

!-----------------------------------------------------------------------
!     /*   memory allocation                                          */
!-----------------------------------------------------------------------

      if ( .not. allocated( pot_string ) ) &
     &   allocate( pot_string(nbead) )

      if ( .not. allocated( s_ref ) ) &
     &   allocate( s_ref(nbead,3*natom) )
      if ( .not. allocated( r1_ref ) ) &
     &   allocate( r1_ref(nbead,3*natom) )
      if ( .not. allocated( r2_ref ) ) &
     &   allocate( r2_ref(nbead,3*natom) )

      if ( .not. allocated( f1_ref ) ) &
     &   allocate( f1_ref(nbead,3*natom) )
      if ( .not. allocated( f2_ref ) ) &
     &   allocate( f2_ref(nbead,3*natom) )

      if ( .not. allocated( pot1_ref ) ) &
     &   allocate( pot1_ref(nbead,1) )
      if ( .not. allocated( pot2_ref ) ) &
     &   allocate( pot2_ref(nbead,1) )

      if ( .not. allocated( arc_ref ) ) &
     &   allocate( arc_ref(narc,1) )
      if ( .not. allocated( s1_ref ) ) &
     &   allocate( s1_ref(narc,1) )
      if ( .not. allocated( s2_ref ) ) &
     &   allocate( s2_ref(narc,1) )

      if ( .not. allocated( rc_arc ) ) &
     &   allocate( rc_arc(narc) )
      if ( .not. allocated( pot_arc ) ) &
     &   allocate( pot_arc(narc) )

      if ( .not. allocated( xmax_string ) ) &
     &   allocate( xmax_string(natom) )
      if ( .not. allocated( ymax_string ) ) &
     &   allocate( ymax_string(natom) )
      if ( .not. allocated( zmax_string ) ) &
     &   allocate( zmax_string(natom) )
      if ( .not. allocated( dmax_string ) ) &
     &   allocate( dmax_string(3*natom) )

!-----------------------------------------------------------------------
!     /*   setup masses                                               */
!-----------------------------------------------------------------------

      call init_mass_string

!-----------------------------------------------------------------------
!     /*   setup initial coordinates                                  */
!-----------------------------------------------------------------------

      dtmax_string = dt

      if ( ipos_start .eq. 3 ) then

!        /*   restart   */
         call restart_string( 1 )

      else

!        /*   initialize path   */
         call init_string

      end if

      return
      end
