!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     set up steepest descent dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setup_sd
!***********************************************************************
!=======================================================================
!
!     set up steepest descent
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, x, y, z, ipos_start, nstep, iounit

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   set up atomic positions and velocities                     */
!-----------------------------------------------------------------------

!     /*   centroid coordinates are read from file                    */
      if     ( ipos_start .eq. 0 ) then

         call init_centroid

         x(:,1) = ux(:,1)
         y(:,1) = uy(:,1)
         z(:,1) = uz(:,1)

      else if ( ipos_start .eq. 1 ) then

         call restart_cartesian( 1 )

         ux(:,1) = x(:,1)
         uy(:,1) = y(:,1)
         uz(:,1) = z(:,1)

      else

         call error_handling( 1, 'subroutine setup_sd', 19 )

      end if

!-----------------------------------------------------------------------
!     /*   terminate the run if nstep = 0                             */
!-----------------------------------------------------------------------

      if ( nstep .eq. 0 ) then

         stop

      end if

      return
      end
