!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jun 25, 2021 by M. Shiga
!      Description:     set up path integral molecular dynamics (NVT)
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setup_pimd_nvt_nhc
!***********************************************************************
!=======================================================================
!
!     set up pimd in nvt ensemble (nose-hoover chain)
!
!=======================================================================
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ivel_start, ibath_start, ipos_start, iounit, nstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   parameters for Suzuki-Yoshida propagator ( order = nys )   */
!-----------------------------------------------------------------------

      call suzuki_yoshida

!-----------------------------------------------------------------------
!     /*   path integral parameters                                   */
!-----------------------------------------------------------------------

      call setpiparams

!-----------------------------------------------------------------------
!     /*   get normal mode transformation matrix                      */
!-----------------------------------------------------------------------

      call nm_matrix

!-----------------------------------------------------------------------
!     /*   thermostat masses for path integral MD                     */
!-----------------------------------------------------------------------

      call setup_qmass_pimd

!-----------------------------------------------------------------------
!     /*   real and fictitous masses of normal modes                  */
!-----------------------------------------------------------------------

      call init_mass_pimd

!-----------------------------------------------------------------------
!     /*   set up atomic positions and velocities                     */
!-----------------------------------------------------------------------

!     /*   centroid coordinates are read from file, and               */
!     /*   non-centroid modes are in Gaussian distribution            */
      if     ( ipos_start .eq. 0 ) then
         call init_centroid
         call init_mode
!     /*   read normal mode position                                  */
      else if ( ipos_start .eq. 1 ) then
         call restart_position( 1 )
!     /*   read Cartesian position                                    */
      else if ( ipos_start .eq. 2 ) then
         call restart_position( 2 )
      else
         call error_handling &
     &      ( 1, 'subroutine setup_pimd_nvt_nhc', 29 )
      end if

!     /*   Maxwell distribution of velocities                         */
      if     ( ivel_start .eq. 0 ) then
         call init_velocity
      else if ( ivel_start .eq. 1 ) then
!        /*   read normal mode momentum (scaled)                      */
         call restart_velocity( 1 )
      else if ( ivel_start .eq. 2 ) then
!        /*   read Cartesian momentum                                 */
         call restart_velocity( 2 )
      else
         call error_handling &
     &      ( 1, 'subroutine setup_pimd_nvt_nhc', 29 )
      end if

!-----------------------------------------------------------------------
!     /*   subtract translational and rotational part of velocities   */
!-----------------------------------------------------------------------

      call correct_velocity

!-----------------------------------------------------------------------
!     /*   set up thermostat positions and velocities                 */
!-----------------------------------------------------------------------

!     /*   for initial start   */

      if ( ibath_start .le. 0 ) then
!        /*   Maxwell distribution of thermostat velocities   */
         call init_bath_nhc

!     /*   for restart   */

      else if ( ibath_start .eq. 1 ) then
!        /*   read in thermostat position and momentum   */
         call restart_bath_nhc( 1 )
      else if ( ibath_start .eq. 2 ) then
!        /*   read in thermostat position and momentum   */
         call restart_bath_nhc( 1 )
      else
      call error_handling &
     &   ( 1, 'subroutine setup_pimd_nvt_nhc', 29 )
      end if

!-----------------------------------------------------------------------
!     /*   terminate the run if nstep = 0                             */
!-----------------------------------------------------------------------

      if ( nstep .eq. 0 ) then

         call backup_pimd_nvt_nhc

         stop

      end if

!-----------------------------------------------------------------------
!     /*   constraints                                                */
!-----------------------------------------------------------------------

      call setup_cons

      return
      end





!***********************************************************************
      subroutine setup_pimd_nvt_nhcs
!***********************************************************************
!=======================================================================
!
!     set up pimd in nvt ensemble (nose-hoover chains)
!
!=======================================================================
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ivel_start, ibath_start, ipos_start, iounit, nstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   parameters for Suzuki-Yoshida propagator ( order = nys )   */
!-----------------------------------------------------------------------

      call suzuki_yoshida

!-----------------------------------------------------------------------
!     /*   path integral parameters                                   */
!-----------------------------------------------------------------------

      call setpiparams

!-----------------------------------------------------------------------
!     /*   get normal mode transformation matrix                      */
!-----------------------------------------------------------------------

      call nm_matrix

!-----------------------------------------------------------------------
!     /*   thermostat masses for path integral MD                     */
!-----------------------------------------------------------------------

      call setup_qmass_pimd

!-----------------------------------------------------------------------
!     /*   real and fictitous masses of normal modes                  */
!-----------------------------------------------------------------------

      call init_mass_pimd

!-----------------------------------------------------------------------
!     /*   set up atomic positions and velocities                     */
!-----------------------------------------------------------------------

!     /*   centroid coordinates are read from file, and               */
!     /*   non-centroid modes are in Gaussian distribution            */
      if     ( ipos_start .eq. 0 ) then
         call init_centroid
         call init_mode
!     /*   read normal mode position                                  */
      else if ( ipos_start .eq. 1 ) then
         call restart_position( 1 )
!     /*   read Cartesian position                                    */
      else if ( ipos_start .eq. 2 ) then
         call restart_position( 2 )
      else
         call error_handling &
     &      ( 1, 'subroutine setup_pimd_nvt_nhcs', 30 )
      end if

!     /*   Maxwell distribution of velocities                         */
      if     ( ivel_start .eq. 0 ) then
         call init_velocity
      else if ( ivel_start .eq. 1 ) then
!        /*   read normal mode momentum (scaled)                      */
         call restart_velocity( 1 )
      else if ( ivel_start .eq. 2 ) then
!        /*   read Cartesian momentum                                 */
         call restart_velocity( 2 )
      else
         call error_handling &
     &      ( 1, 'subroutine setup_pimd_nvt_nhcs', 30 )
      end if

!-----------------------------------------------------------------------
!     /*   subtract translational and rotational part of velocities   */
!-----------------------------------------------------------------------

      call correct_velocity

!-----------------------------------------------------------------------
!     /*   set up thermostat positions and velocities                 */
!-----------------------------------------------------------------------

!     /*   for initial start   */

      if ( ibath_start .le. 0 ) then
!        /*   Maxwell distribution of thermostat velocities   */
         call init_bath_nhcs

!     /*   for restart   */

      else if ( ibath_start .eq. 1 ) then
!        /*   read in thermostat position and momentum   */
         call restart_bath_nhcs( 1 )
      else if ( ibath_start .eq. 2 ) then
!        /*   read in thermostat position and momentum   */
         call restart_bath_nhcs( 1 )
      else
         call error_handling &
     &      ( 1, 'subroutine setup_pimd_nvt_nhcs', 30 )
      end if

!-----------------------------------------------------------------------
!     /*   terminate the run if nstep = 0                             */
!-----------------------------------------------------------------------

      if ( nstep .eq. 0 ) then

         call backup_pimd_nvt_nhcs

         stop

      end if

!-----------------------------------------------------------------------
!     /*   constraints                                                */
!-----------------------------------------------------------------------

      call setup_cons

      return
      end





!***********************************************************************
      subroutine setup_pimd_nvt_mnhc
!***********************************************************************
!=======================================================================
!
!     set up pimd in nvt ensemble (massive nose-hoover chains)
!
!=======================================================================
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ivel_start, ibath_start, ipos_start, iounit, nstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   parameters for Suzuki-Yoshida propagator ( order = nys )   */
!-----------------------------------------------------------------------

      call suzuki_yoshida

!-----------------------------------------------------------------------
!     /*   path integral parameters                                   */
!-----------------------------------------------------------------------

      call setpiparams

!-----------------------------------------------------------------------
!     /*   get normal mode transformation matrix                      */
!-----------------------------------------------------------------------

      call nm_matrix

!-----------------------------------------------------------------------
!     /*   thermostat masses for path integral MD                     */
!-----------------------------------------------------------------------

      call setup_qmass_pimd

!-----------------------------------------------------------------------
!     /*   real and fictitous masses of normal modes                  */
!-----------------------------------------------------------------------

      call init_mass_pimd

!-----------------------------------------------------------------------
!     /*   set up atomic positions and velocities                     */
!-----------------------------------------------------------------------

!     /*   centroid coordinates are read from file, and               */
!     /*   non-centroid modes are in Gaussian distribution            */
      if     ( ipos_start .eq. 0 ) then
         call init_centroid
         call init_mode
!     /*   read normal mode position                                  */
      else if ( ipos_start .eq. 1 ) then
         call restart_position( 1 )
!     /*   read Cartesian position                                    */
      else if ( ipos_start .eq. 2 ) then
         call restart_position( 2 )
      else
         call error_handling &
     &      ( 1, 'subroutine setup_pimd_nvt_mnhc', 30 )
      end if

!     /*   Maxwell distribution of velocities                         */
      if     ( ivel_start .eq. 0 ) then
         call init_velocity
      else if ( ivel_start .eq. 1 ) then
!        /*   read normal mode momentum (scaled)                      */
         call restart_velocity( 1 )
      else if ( ivel_start .eq. 2 ) then
!        /*   read Cartesian momentum                                 */
         call restart_velocity( 2 )
      else
         call error_handling &
     &      ( 1, 'subroutine setup_pimd_nvt_mnhc', 30 )
      end if

!-----------------------------------------------------------------------
!     /*   subtract translational and rotational part of velocities   */
!-----------------------------------------------------------------------

      call correct_velocity

!-----------------------------------------------------------------------
!     /*   set up thermostat positions and velocities                 */
!-----------------------------------------------------------------------

!     /*   for initial start   */

      if ( ibath_start .le. 0 ) then
!        /*   Maxwell distribution of thermostat velocities   */
         call init_bath_mnhc

!     /*   for restart   */

      else if ( ibath_start .eq. 1 ) then
!        /*   read in thermostat position and momentum   */
         call restart_bath_mnhc( 1 )
      else if ( ibath_start .eq. 2 ) then
!        /*   read in thermostat position and momentum   */
         call restart_bath_mnhc( 1 )
      else
         call error_handling &
     &      ( 1, 'subroutine setup_pimd_nvt_mnhc', 30 )
      end if

!-----------------------------------------------------------------------
!     /*   terminate the run if nstep = 0                             */
!-----------------------------------------------------------------------

      if ( nstep .eq. 0 ) then

         call backup_pimd_nvt_mnhc

         stop

      end if

!-----------------------------------------------------------------------
!     /*   constraints                                                */
!-----------------------------------------------------------------------

      call setup_cons

      return
      end

