!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jan 23, 2025 by M. Shiga
!      Description:     brownian chain molecular dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setup_pibcmd_MPI
!***********************************************************************
!=======================================================================
!
!     set up path integral brownian chain molecular dynamics
!
!=======================================================================
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   hamiltonian_cor, ivel_start, ipos_start, iounit, nstep, &
     &   integrator_bcmd, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: itest, ierr

!-----------------------------------------------------------------------
!     /*   parameters for Suzuki-Yoshida propagator ( order = nys )   */
!-----------------------------------------------------------------------

      call suzuki_yoshida

!-----------------------------------------------------------------------
!     /*   path integral parameters                                   */
!-----------------------------------------------------------------------

      call setpiparams_MPI

!-----------------------------------------------------------------------
!     /*   get normal mode transformation matrix                      */
!-----------------------------------------------------------------------

      call nm_matrix_MPI

!-----------------------------------------------------------------------
!     /*   real and fictitous masses of normal modes                  */
!-----------------------------------------------------------------------

      call init_mass_pibcmd_MPI

!-----------------------------------------------------------------------
!     /*   set up atomic positions and velocities                     */
!-----------------------------------------------------------------------

!     /*   centroid coordinates are read from file, and               */
!     /*   non-centroid modes are in Gaussian distribution            */
      if     ( ipos_start .eq. 0 ) then
         call init_centroid_MPI
         call init_mode_MPI
!     /*   read normal mode position                                  */
      else if ( ipos_start .eq. 1 ) then
         call restart_position_MPI( 1 )
!     /*   read Cartesian position                                    */
      else if ( ipos_start .eq. 2 ) then
         call restart_position_MPI( 2 )
      else
         call error_handling_MPI( 1, 'subroutine setup_pibcmd_MPI', 27)
      end if

!     /*   Maxwell distribution of velocities                         */
      if     ( ivel_start .eq. 0 ) then
         call init_velocity_MPI
      else if ( ivel_start .eq. 1 ) then
!        /*   read normal mode momentum (scaled)                      */
         call restart_velocity_MPI( 1 )
      else if ( ivel_start .eq. 2 ) then
!        /*   read Cartesian momentum                                 */
         call restart_velocity_MPI( 2 )
      else
         call error_handling_MPI( 1, 'subroutine setup_pibcmd_MPI', 27)
      end if

!-----------------------------------------------------------------------
!     /*   integrator                                                 */
!-----------------------------------------------------------------------

      call read_char_MPI &
     &   ( integrator_bcmd, 12, '<integrator_bcmd>', 17, iounit )

!-----------------------------------------------------------------------
!     /*   subtract translational and rotational part of velocities   */
!-----------------------------------------------------------------------

      call correct_velocity_MPI

!-----------------------------------------------------------------------
!     /*   initialize energy correction                               */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

         call testfile ( 'step.ini', 8, itest )

         if ( itest .eq. 0 ) then

            open ( iounit, file = 'step.ini' )

            read ( iounit, *, iostat=ierr )
            read ( iounit, *, iostat=ierr ) hamiltonian_cor

            close( iounit )

            if ( ierr .ne. 0 ) hamiltonian_cor = 0.d0

         else

            hamiltonian_cor = 0.d0

         end if

      end if

      call my_mpi_bcast_real_0( hamiltonian_cor )

!-----------------------------------------------------------------------
!     /*   terminate the run if nstep = 0                             */
!-----------------------------------------------------------------------

      if ( nstep .eq. 0 ) then

         call backup_pibcmd_MPI

         stop

      end if

!-----------------------------------------------------------------------
!     /*   constraints                                                */
!-----------------------------------------------------------------------

      call setup_cons_MPI

      return
      end
