!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jan 7, 2019 by M. Shiga
!      Description:     set up normal mode analysis
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setup_nma_MPI
!***********************************************************************
!=======================================================================
!
!     set up normal mode analysis
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, x, y, z, ipos_start, nstep, natom, iounit

      use nma_variables, only : &
     &   hess, redmass, eigval, eigvec

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   set up atomic positions and velocities                     */
!-----------------------------------------------------------------------

!     /*   centroid coordinates are read from file                    */
      if     ( ipos_start .eq. 0 ) then

         call init_centroid_MPI

         x(:,1) = ux(:,1)
         y(:,1) = uy(:,1)
         z(:,1) = uz(:,1)

      else if ( ipos_start .eq. 1 ) then

         call restart_cartesian_MPI( 5 )

         ux(:,1) = x(:,1)
         uy(:,1) = y(:,1)
         uz(:,1) = z(:,1)

      else

         call error_handling_MPI( 1, 'subroutine setup_nma_MPI', 24 )

      end if

!-----------------------------------------------------------------------
!     /*   terminate the run if nstep = 0                             */
!-----------------------------------------------------------------------

      if ( nstep .eq. 0 ) then

         call my_mpi_finalize_2

         stop

      end if

!-----------------------------------------------------------------------
!     /*   memory allocation                                          */
!-----------------------------------------------------------------------

      if ( .not. allocated( hess ) ) &
     &   allocate( hess(3*natom,3*natom) )

      if ( .not. allocated( redmass ) ) &
     &   allocate( redmass(3*natom) )

      if ( .not. allocated( eigval ) ) &
     &   allocate( eigval(3*natom) )

      if ( .not. allocated( eigvec ) ) &
     &   allocate( eigvec(3*natom,3*natom) )

      return
      end
