!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jun 25, 2021 by M. Shiga
!      Description:     set up multiscale simulations
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setup_multi_me
!***********************************************************************
!=======================================================================
!
!     set up multiple time scale pimd
!
!=======================================================================
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   pi, dt, nref, nbead, ncolor, ipos_start, ivel_start, iounit, &
     &   ibath_start, nnhc, nstep

      use qmmm_variables, only : &
     &   qmass_cent_multi_a, qmass_cent_multi_b, qmass_multi_b, &
     &   qmass_multi_a, dt_multi, dt_multi_ref, nmulti

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   setup mechanical embedding                                 */
!-----------------------------------------------------------------------

      call setup_me

!-----------------------------------------------------------------------
!     /*   setup mm                                                   */
!-----------------------------------------------------------------------

      call force_me_setup

!-----------------------------------------------------------------------
!     /*   setup best                                                 */
!-----------------------------------------------------------------------

      call setup_best

!-----------------------------------------------------------------------
!     /*   parameters for Suzuki-Yoshida propagator ( order = nys )   */
!-----------------------------------------------------------------------

      call suzuki_yoshida

!-----------------------------------------------------------------------
!     /*   path integral parameters                                   */
!-----------------------------------------------------------------------

      call setpiparams

!-----------------------------------------------------------------------
!     /*   get normal mode transformation matrix                      */
!-----------------------------------------------------------------------

      call nm_matrix

!-----------------------------------------------------------------------
!     /*   read multiple time step parameter                          */
!-----------------------------------------------------------------------

      call read_int1 ( nmulti, '<nmulti>', 8, iounit )

!-----------------------------------------------------------------------
!     /*   step size                                                  */
!-----------------------------------------------------------------------

!     /*   multiple time steps:  low layer centroid      */
      dt_multi      =  dt/nmulti

!     /*   multiple time steps:  low layer non-centroid  */
      dt_multi_ref  =  dt_multi/nref

!-----------------------------------------------------------------------
!     /*   memory allocation                                          */
!-----------------------------------------------------------------------

      if ( .not. allocated( qmass_multi_a ) ) &
     &   allocate( qmass_multi_a(nbead) )
      if ( .not. allocated( qmass_multi_b ) ) &
     &   allocate( qmass_multi_b(nbead) )
      if ( .not. allocated( qmass_cent_multi_a ) ) &
     &   allocate( qmass_cent_multi_a(nnhc,ncolor) )
      if ( .not. allocated( qmass_cent_multi_b ) ) &
     &   allocate( qmass_cent_multi_b(nnhc,ncolor) )

!-----------------------------------------------------------------------
!     /*   thermostat masses for path integral MD                     */
!-----------------------------------------------------------------------

      call setup_qmass_multi

!-----------------------------------------------------------------------
!     /*   real and fictitous masses of normal modes                  */
!-----------------------------------------------------------------------

      call init_mass_multi_me

!-----------------------------------------------------------------------
!     /*   set up atomic positions and velocities                     */
!-----------------------------------------------------------------------

!     /*   centroid coordinates are read from file, and               */
!     /*   non-centroid modes are in Gaussian distribution            */
      if     ( ipos_start .eq. 0 ) then
         call init_centroid
         call init_mode
!     /*   read normal mode position                                  */
      else if ( ipos_start .eq. 1 ) then
         call restart_position( 1 )
!     /*   read Cartesian position                                    */
      else if ( ipos_start .eq. 2 ) then
         call restart_position( 2 )
      else
         call error_handling( 1, 'subroutine setup_multi_me', 25 )
      end if

!     /*   Maxwell distribution of velocities                         */
      if     ( ivel_start .eq. 0 ) then
         call init_velocity
      else if ( ivel_start .eq. 1 ) then
!        /*   read normal mode momentum (scaled)                      */
         call restart_velocity( 1 )
      else if ( ivel_start .eq. 2 ) then
!        /*   read Cartesian momentum                                 */
         call restart_velocity( 2 )
      else
         call error_handling( 1, 'subroutine setup_multi_me', 25 )
      end if

!-----------------------------------------------------------------------
!     /*   subtract translational and rotational part of velocities   */
!-----------------------------------------------------------------------

      call correct_velocity

!-----------------------------------------------------------------------
!     /*   set up thermostat positions and velocities                 */
!-----------------------------------------------------------------------

!     /*   for initial start   */

      if ( ibath_start .le. 0 ) then
!        /*   Maxwell distribution of thermostat velocities   */
         call init_bath_multi_me

!     /*   for restart   */

      else if ( ibath_start .eq. 1 ) then
!        /*   read in thermostat position and momentum   */
         call restart_bath_multi_me( 1 )
      else if ( ibath_start .eq. 2 ) then
!        /*   read in thermostat position and momentum   */
         call restart_bath_multi_me( 1 )
      else
         call error_handling( 1, 'subroutine setup_multi_me', 25 )
      end if

!-----------------------------------------------------------------------
!     /*   terminate the run if nstep = 0                             */
!-----------------------------------------------------------------------

      if ( nstep .eq. 0 ) then

         call backup_multi_me

         stop

      end if

      return
      end
