!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     set up molecular dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setup_md_nve
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ivel_start, ipos_start

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   parameters for Suzuki-Yoshida propagator ( order = nys )   */
!-----------------------------------------------------------------------

      call suzuki_yoshida

!-----------------------------------------------------------------------
!     /*   read input file and memory allocation                      */
!-----------------------------------------------------------------------

      call setmdparams

!-----------------------------------------------------------------------
!     /*   atomic mass                                                */
!-----------------------------------------------------------------------

      call init_mass_md

!-----------------------------------------------------------------------
!     /*   atom position                                              */
!-----------------------------------------------------------------------

      if      ( ipos_start .eq. 0 ) then

!        /*   initialize position   */
         call init_position_cart

!        /*   ux --> x   */
         call nm_trans_cart( 2 )

      else if ( ipos_start .eq. 1 ) then

!        /*   restart position   */
         call restart_position( 2 )

      else

!        /*   error handling   */
         call error_handling( 1, 'subroutine setup_md_nve', 23 )

      end if

!-----------------------------------------------------------------------
!     /*   atom velocity                                              */
!-----------------------------------------------------------------------

      if      ( ivel_start .eq. 0 ) then

!        /*   initialize velocity   */
         call init_velocity_cart

!        /*   vx --> vux   */
         call nm_trans_velocity_cart( 3 )

      else if ( ivel_start .eq. 1 ) then

!        /*   restart velocity   */
         call restart_velocity( 2 )

      else

!        /*   error handling   */
         call error_handling( 1, 'subroutine setup_md_nvt', 23 )

      end if

!-----------------------------------------------------------------------
!     /*   constraints                                                */
!-----------------------------------------------------------------------

      call setup_cons

      return
      end





!***********************************************************************
      subroutine setup_md_nvt
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   qmass_cart, qmass_cart, xbath_cart, ybath_cart, zbath_cart, &
     &   vxbath_cart, vybath_cart, vzbath_cart, fxbath_cart, &
     &   fybath_cart, fzbath_cart, natom, nbead, nnhc, ivel_start, &
     &   ipos_start, ibath_start, ncolor

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   parameters for Suzuki-Yoshida propagator ( order = nys )   */
!-----------------------------------------------------------------------

      call suzuki_yoshida

!-----------------------------------------------------------------------
!     /*   read input file and memory allocation                      */
!-----------------------------------------------------------------------

      call setmdparams

!-----------------------------------------------------------------------
!     /*   atomic mass                                                */
!-----------------------------------------------------------------------

      call init_mass_md

!-----------------------------------------------------------------------
!     /*   atom position                                              */
!-----------------------------------------------------------------------

      if      ( ipos_start .eq. 0 ) then

!        /*   initialize position   */
         call init_position_cart

!        /*   ux --> x   */
         call nm_trans_cart( 2 )

      else if ( ipos_start .eq. 1 ) then

!        /*   restart position   */
         call restart_position( 2 )

      else

!        /*   error handling   */
         call error_handling( 1, 'subroutine setup_md_nvt', 23 )

      end if

!-----------------------------------------------------------------------
!     /*   atom velocity                                              */
!-----------------------------------------------------------------------

      if      ( ivel_start .eq. 0 ) then

!        /*   initialize velocity   */
         call init_velocity_cart

!        /*   vx --> vux   */
         call nm_trans_velocity_cart( 3 )

      else if ( ivel_start .eq. 1 ) then

!        /*   restart velocity   */
         call restart_velocity( 2 )

      else

!        /*   error handling   */
         call error_handling( 1, 'subroutine setup_md_nvt', 23 )

      end if

!-----------------------------------------------------------------------
!     /*   REVISED: thermostats                                       */
!-----------------------------------------------------------------------

      if ( .not. allocated( qmass_cart ) ) &
     &   allocate( qmass_cart(nnhc,ncolor) )

      if ( .not. allocated( xbath_cart ) ) &
     &   allocate( xbath_cart(natom,nnhc,ncolor,nbead) )
      if ( .not. allocated( ybath_cart ) ) &
     &   allocate( ybath_cart(natom,nnhc,ncolor,nbead) )
      if ( .not. allocated( zbath_cart ) ) &
     &   allocate( zbath_cart(natom,nnhc,ncolor,nbead) )

      if ( .not. allocated( vxbath_cart ) ) &
     &   allocate( vxbath_cart(natom,nnhc,ncolor,nbead) )
      if ( .not. allocated( vybath_cart ) ) &
     &   allocate( vybath_cart(natom,nnhc,ncolor,nbead) )
      if ( .not. allocated( vzbath_cart ) ) &
     &   allocate( vzbath_cart(natom,nnhc,ncolor,nbead) )

      if ( .not. allocated( fxbath_cart ) ) &
     &   allocate( fxbath_cart(natom,nnhc,ncolor,nbead) )
      if ( .not. allocated( fybath_cart ) ) &
     &   allocate( fybath_cart(natom,nnhc,ncolor,nbead) )
      if ( .not. allocated( fzbath_cart ) ) &
     &   allocate( fzbath_cart(natom,nnhc,ncolor,nbead) )

!-----------------------------------------------------------------------
!     /*   thermostat mass attached to system                         */
!-----------------------------------------------------------------------

       call setup_qmass_md

!-----------------------------------------------------------------------
!     /*   position and velocity of all thermostats                   */
!-----------------------------------------------------------------------

      if ( ibath_start .le. 0 ) then

!        /*   initialize thermostats   */
!        call init_bath_cart

!        /*   REVISED: initialize thermostats   */
         call init_bath_cart_revised

      else if ( ibath_start .eq. 1 ) then

!        /*   restart thermostats   */
!        call restart_bath_cart( 1 )

!        /*   REVISED: restart thermostats   */
         call restart_bath_cart_revised( 1 )

      end if

!-----------------------------------------------------------------------
!     /*   constraints                                                */
!-----------------------------------------------------------------------

      call setup_cons

      return
      end
