!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jun 25, 2021 by M. Shiga
!      Description:     set up geometry
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setup_geometry
!***********************************************************************
!=======================================================================
!
!     set up geometry
!
!=======================================================================
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ipos_start, nstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   get normal mode transformation matrix                      */
!-----------------------------------------------------------------------

      call nm_matrix

!-----------------------------------------------------------------------
!     /*   path integral parameters                                   */
!-----------------------------------------------------------------------

      call setpiparams

!-----------------------------------------------------------------------
!     /*   real and fictitous masses of normal modes                  */
!-----------------------------------------------------------------------

      call init_mass_pimd

!-----------------------------------------------------------------------
!     /*   set up atomic positions and velocities                     */
!-----------------------------------------------------------------------

!     /*   centroid coordinates are read from file, and               */
!     /*   non-centroid modes are in Gaussian distribution            */
      if     ( ipos_start .eq. 0 ) then
         call init_centroid
         call init_mode
!     /*   read normal mode position                                  */
      else if ( ipos_start .eq. 1 ) then
         call restart_position( 1 )
!     /*   read Cartesian position                                    */
      else if ( ipos_start .eq. 2 ) then
         call restart_position( 2 )
      else
         call error_handling( 1, 'subroutine setup_geometry', 25 )
      end if

!c     /*   Maxwell distribution of velocities                         *
!      if     ( ivel_start .eq. 0 ) then
!         call init_velocity
!      else if ( ivel_start .eq. 1 ) then
!c        /*   read normal mode momentum (scaled)                      *
!         call restart_velocity( 1 )
!      else if ( ivel_start .eq. 2 ) then
!c        /*   read Cartesian momentum                                 *
!         call restart_velocity( 2 )
!      else
!         call error_handling( 1, 'subroutine setup_geometry', 25 )
!      end if

!-----------------------------------------------------------------------
!     /*   terminate the run if nstep = 0                             */
!-----------------------------------------------------------------------

      if ( nstep .eq. 0 ) then

         stop

      end if

      return
      end
