!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    June 16, 2020 by M. Shiga
!      Description:     static elastic constant
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setup_elastic_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, x, y, z, vx, vy, vz, vux, vuy, vuz, fdiff, box, &
     &   ipos_start, ibox_start, iounit, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ierr

      character(len=80) :: char_line

      real(8) :: small = 1.d-2

!-----------------------------------------------------------------------
!     /*   finite difference parameter                                */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

         ierr = 0

         open ( iounit, file = 'input.dat' )
         do
            read ( iounit, *, iostat=ierr )  char_line
            if ( char_line(1:7) .eq. '<fdiff>' ) then
               read( iounit, *, iostat=ierr ) fdiff
               exit
            end if
            if ( ierr .ne. 0 ) exit
         end do
         close( iounit )

         if ( ierr .ne. 0 )  then
         open ( iounit, file = 'input_default.dat' )
            do
               read ( iounit, *, iostat=ierr )  char_line
               if ( char_line(1:7) .eq. '<fdiff>' ) then
                  read( iounit, *, iostat=ierr ) fdiff
                  exit
               end if
               if ( ierr .ne. 0 ) exit
            end do
         close( iounit )
         end if

      end if

      call my_mpi_bcast_int_0 ( ierr )

      if ( myrank .eq. 0 ) then
         if ( ierr .ne. 0 ) then
            write( 6, '(a)' ) 'Error - <fdiff> read incorrectly.'
            write( 6, '(a)' )
         end if
      end if

      call error_handling_MPI &
     &   ( ierr, 'subroutine setup_elastic_MPI', 28 )

      call my_mpi_bcast_real_0 ( fdiff )

!-----------------------------------------------------------------------
!     /*   set up atomic positions and velocities                     */
!-----------------------------------------------------------------------

!     /*   centroid coordinates are read from file                    */
      if     ( ipos_start .eq. 0 ) then

         call init_centroid_MPI

         x(:,1) = ux(:,1)
         y(:,1) = uy(:,1)
         z(:,1) = uz(:,1)

      else if ( ipos_start .eq. 1 ) then

         call restart_cartesian_MPI( 1 )

         ux(:,1) = x(:,1)
         uy(:,1) = y(:,1)
         uz(:,1) = z(:,1)

      else

         call error_handling_MPI &
     &      ( 1, 'subroutine setup_elastic_MPI', 28 )

      end if

!-----------------------------------------------------------------------
!     /*   set up simulation box                                      */
!-----------------------------------------------------------------------

      if      ( ibox_start .eq. 0 ) then
         call init_box_position_MPI
      else if ( ibox_start .eq. 1 ) then
         call restart_box_MPI( 1 )
      else
         call error_handling_MPI &
     &      ( 1, 'subroutine setup_elastic_MPI', 28 )
      end if

!-----------------------------------------------------------------------
!     //   initialize:  velocity - not used
!-----------------------------------------------------------------------

      vx(:,1) = 0.d0
      vy(:,1) = 0.d0
      vz(:,1) = 0.d0

      vux(:,1) = 0.d0
      vuy(:,1) = 0.d0
      vuz(:,1) = 0.d0

!-----------------------------------------------------------------------
!     //   orthorhombic box is assumed
!-----------------------------------------------------------------------

      ierr = 0

      if ( abs(box(1,2)) .gt. small ) ierr = 1
      if ( abs(box(1,3)) .gt. small ) ierr = 1
      if ( abs(box(2,1)) .gt. small ) ierr = 1
      if ( abs(box(2,3)) .gt. small ) ierr = 1
      if ( abs(box(3,1)) .gt. small ) ierr = 1
      if ( abs(box(3,2)) .gt. small ) ierr = 1

      if ( ierr .ne. 0 ) then
         write( 6, '(a)' ) 'Error - Not an orthorhombic box.'
         write( 6, '(a)' )
      end if

      call error_handling_MPI &
     &   ( ierr, 'subroutine setup_elastic_MPI', 28 )

      return
      end
