!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jun 25, 2021 by M. Shiga
!      Description:     set up centroid molecular dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setup_cmd_MPI
!***********************************************************************
!=======================================================================
!
!     set up centroid md
!
!=======================================================================
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ivel_start, ibath_start, ipos_start, iounit, nstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   parameters for Suzuki-Yoshida propagator ( order = nys )   */
!-----------------------------------------------------------------------

      call suzuki_yoshida

!-----------------------------------------------------------------------
!     /*   path integral parameters                                   */
!-----------------------------------------------------------------------

      call setpiparams_MPI

!-----------------------------------------------------------------------
!     /*   get normal mode transformation matrix                      */
!-----------------------------------------------------------------------

      call nm_matrix_MPI

!-----------------------------------------------------------------------
!     /*   thermostat masses for CMD                                  */
!-----------------------------------------------------------------------

      call setup_qmass_cmd

!-----------------------------------------------------------------------
!     /*   real and fictitous masses of normal modes                  */
!-----------------------------------------------------------------------

      call init_mass_cmd_MPI

!-----------------------------------------------------------------------
!     /*   set up atomic positions and velocities                     */
!-----------------------------------------------------------------------

!     /*   centroid coordinates are read from file, and               */
!     /*   non-centroid modes are in Gaussian distribution            */
      if     ( ipos_start .eq. 0 ) then
         call init_centroid_MPI
         call init_mode_MPI
!     /*   read normal mode position                                  */
      else if ( ipos_start .eq. 1 ) then
         call restart_position_MPI( 1 )
!     /*   read Cartesian position                                    */
      else if ( ipos_start .eq. 2 ) then
         call restart_position_MPI( 2 )
      else
         call error_handling_MPI( 1, 'subroutine setup_cmd_MPI', 24 )
      end if

!     /*   Maxwell distribution of velocities                         */
      if     ( ivel_start .eq. 0 ) then
         call init_velocity_MPI
      else if ( ivel_start .eq. 1 ) then
!        /*   read normal mode momentum (scaled)                      */
         call restart_velocity_MPI( 1 )
      else if ( ivel_start .eq. 2 ) then
!        /*   read Cartesian momentum                                 */
         call restart_velocity_MPI( 2 )
      else
         call error_handling_MPI( 1, 'subroutine setup_cmd_MPI', 24 )
      end if

!-----------------------------------------------------------------------
!     /*   subtract translational and rotational part of velocities   */
!-----------------------------------------------------------------------

      call correct_velocity_MPI

!-----------------------------------------------------------------------
!     /*   set up thermostat positions and velocities                 */
!-----------------------------------------------------------------------

!     /*   for initial start   */

      if ( ibath_start .le. 0 ) then
!        /*   Maxwell distribution of thermostat velocities   */
         call init_bath_nhc_MPI

!     /*   for restart   */

      else if ( ibath_start .eq. 1 ) then
!        /*   read in thermostat position and momentum   */
         call restart_bath_nhc_MPI( 1 )
      else if ( ibath_start .eq. 2 ) then
!        /*   read in thermostat position and momentum   */
         call restart_bath_nhc_MPI( 1 )
      else
         call error_handling_MPI( 1, 'subroutine setup_cmd_MPI', 24 )
      end if

!-----------------------------------------------------------------------
!     /*   terminate the run if nstep = 0                             */
!-----------------------------------------------------------------------

      if ( nstep .eq. 0 ) then

         call backup_cmd_MPI

         call my_mpi_finalize_2

         stop

      end if

!-----------------------------------------------------------------------
!     /*   constraints                                                */
!-----------------------------------------------------------------------

      call setup_cons_MPI

      return
      end

