!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     set up post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setup_calc
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : ncalc

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   xyz file                                                   */
!-----------------------------------------------------------------------

      call calc_xyz_setup

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( ncalc .ge. 1 ) write( 6, '(a,2i4,a)' ) 'Print setups:'

!-----------------------------------------------------------------------
!     /*   distance                                                   */
!-----------------------------------------------------------------------

      call calc_lin_setup

!-----------------------------------------------------------------------
!     /*   angle                                                      */
!-----------------------------------------------------------------------

      call calc_angl_setup

!-----------------------------------------------------------------------
!     /*   dihedral                                                   */
!-----------------------------------------------------------------------

      call calc_dih_setup

!-----------------------------------------------------------------------
!     /*   distance                                                   */
!-----------------------------------------------------------------------

      call calc_lin_avg_setup

!-----------------------------------------------------------------------
!     /*   angle                                                      */
!-----------------------------------------------------------------------

      call calc_angl_avg_setup

!-----------------------------------------------------------------------
!     /*   dihedral                                                   */
!-----------------------------------------------------------------------

      call calc_dih_avg_setup

!-----------------------------------------------------------------------
!     /*   difference                                                 */
!-----------------------------------------------------------------------

      call calc_diff_setup

!-----------------------------------------------------------------------
!     /*   absolute difference                                        */
!-----------------------------------------------------------------------

      call calc_adiff_setup

!-----------------------------------------------------------------------
!     /*   distance from plane                                        */
!-----------------------------------------------------------------------

      call calc_opd_setup

!-----------------------------------------------------------------------
!     /*   out of plane angle                                         */
!-----------------------------------------------------------------------

      call calc_opa_setup

!-----------------------------------------------------------------------
!     /*   area of triangle                                           */
!-----------------------------------------------------------------------

      call calc_tri_setup

!-----------------------------------------------------------------------
!     /*   distance (species)                                         */
!-----------------------------------------------------------------------

      call calc_lin_spec_setup

!-----------------------------------------------------------------------
!     /*   angle (species)                                            */
!-----------------------------------------------------------------------

      call calc_angl_spec_setup

!-----------------------------------------------------------------------
!     /*   dihedral (species)                                         */
!-----------------------------------------------------------------------

      call calc_dih_spec_setup

!-----------------------------------------------------------------------
!     /*   distance distribution                                      */
!-----------------------------------------------------------------------

      call calc_lin_atom_dens_setup

!-----------------------------------------------------------------------
!     /*   angular distribution                                       */
!-----------------------------------------------------------------------

      call calc_angl_atom_dens_setup

!-----------------------------------------------------------------------
!     /*   dihedral distribution                                      */
!-----------------------------------------------------------------------

      call calc_dih_atom_dens_setup

!-----------------------------------------------------------------------
!     /*   distance distribution (species)                            */
!-----------------------------------------------------------------------

      call calc_lin_spec_dens_setup

!-----------------------------------------------------------------------
!     /*   angular distribution (species)                             */
!-----------------------------------------------------------------------

      call calc_angl_spec_dens_setup

!-----------------------------------------------------------------------
!     /*   dihedral distribution (species)                            */
!-----------------------------------------------------------------------

      call calc_dih_spec_dens_setup

!-----------------------------------------------------------------------
!     /*   difference                                                 */
!-----------------------------------------------------------------------

      call calc_diff_atom_dens_setup

!-----------------------------------------------------------------------
!     /*   absolute difference                                        */
!-----------------------------------------------------------------------

      call calc_adiff_atom_dens_setup

!-----------------------------------------------------------------------
!     /*   two-dimensional distance-angle distribution (species)      */
!-----------------------------------------------------------------------

      call calc_xla_spec_dens_setup

!-----------------------------------------------------------------------
!     /*   3d cube                                                    */
!-----------------------------------------------------------------------

      call calc_cube_setup

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( ncalc .ge. 1 ) write( 6, '(a)' )

!-----------------------------------------------------------------------
!     /*   check reading trj.out                                      */
!-----------------------------------------------------------------------

      call calc_read_setup

      return
      end
