!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     set up initial geometry and simulation box
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setup_boxopt
!***********************************************************************
!=======================================================================
!
!     set up box optimization
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, x, y, z, vx, vy, vz, vux, vuy, vuz, &
     &   ipos_start, nstep, iounit

      use lbfgs_variables, only : &
     &   pos, pos0, grad, dm, ws, dmax_tol, drms_tol, fmax_tol, &
     &   frms_tol, nwork, ndim, nup, iflag

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ierr

!-----------------------------------------------------------------------
!     /*   set up atomic positions and velocities                     */
!-----------------------------------------------------------------------

!     /*   centroid coordinates are read from file                    */
      if     ( ipos_start .eq. 0 ) then

         call init_centroid

         x(:,1) = ux(:,1)
         y(:,1) = uy(:,1)
         z(:,1) = uz(:,1)

      else if ( ipos_start .eq. 1 ) then

         call restart_cartesian( 1 )

         ux(:,1) = x(:,1)
         uy(:,1) = y(:,1)
         uz(:,1) = z(:,1)

      else

         call error_handling( 1, 'subroutine setup_boxopt', 23 )

      end if

!-----------------------------------------------------------------------
!     //   initialize:  velocity - not used
!-----------------------------------------------------------------------

      vx(:,1) = 0.d0
      vy(:,1) = 0.d0
      vz(:,1) = 0.d0

      vux(:,1) = 0.d0
      vuy(:,1) = 0.d0
      vuz(:,1) = 0.d0

!-----------------------------------------------------------------------
!     /*   terminate the run if nstep = 0                             */
!-----------------------------------------------------------------------

      if ( nstep .eq. 0 ) then

         stop

      end if

!-----------------------------------------------------------------------
!     //   allocation
!-----------------------------------------------------------------------

!     //   number of degrees of freedom
      ndim  = 9

!     //   dimension of the workspace in lbfgs
      nwork = ndim*(2*nup+1)+2*nup

!     //   coordinates
      if ( .not. allocated( pos ) ) &
     &   allocate( pos(ndim) )

!     //   old coordinates
      if ( .not. allocated( pos0 ) ) &
     &   allocate( pos0(ndim) )

!     //   gradient
      if ( .not. allocated( grad ) ) &
     &   allocate( grad(ndim) )

!     //   diagonal matrix in lbfgs
      if ( .not. allocated( dm ) ) &
     &   allocate( dm(ndim) )

!     //   workspace in lbfgs
      if ( .not. allocated( ws ) ) &
     &   allocate( ws(nwork) )

!-----------------------------------------------------------------------
!     //   initialize:  convergence flag
!-----------------------------------------------------------------------

      iflag = 0

!-----------------------------------------------------------------------
!     //   initialize:  read lbfgs parameters
!-----------------------------------------------------------------------

!     /*   file open   */
      open ( iounit, file = 'input.dat' )

      call search_tag ( '<params_lbfgs>', 14, iounit, ierr )

!     /*   read data   */
      read ( iounit, *, iostat=ierr ) &
     &   dmax_tol, drms_tol, fmax_tol, frms_tol

      close( iounit )

      if ( ierr .ne. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input_default.dat' )

         call search_tag ( '<params_lbfgs>', 14, iounit, ierr )

!        /*   read data   */
         read ( iounit, *, iostat=ierr ) &
     &      dmax_tol, drms_tol, fmax_tol, frms_tol

         close( iounit )

      end if

      return
      end
