!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     set up simulation parameters for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setparams_calc
!***********************************************************************
!=======================================================================
!
!     set up parameters
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   natom, nbead, nkind, iounit, input_style, mspec, species, ikind

      implicit none

      integer :: itest

!-----------------------------------------------------------------------
!     test if input file exist
!-----------------------------------------------------------------------

      call testfile ( 'calc.dat', 8, itest, iounit )

      if ( itest .eq. 1 ) then
         write ( 6, '(a)' ) 'Error - file missing: calc.dat.'
         write ( 6, '(a)' )
         call error_handling_calc &
     &      ( 1, 'subroutine setparams_calc', 25 )
      end if

      call testfile ( 'calc_default.dat', 16, itest, iounit )

      if ( itest .eq. 1 ) then
         write ( 6, '(a)' ) 'Error - file missing: calc_default.dat.'
         write ( 6, '(a)' )
         call error_handling_calc &
     &      ( 1, 'subroutine setparams_calc', 25 )
      end if

!-----------------------------------------------------------------------
!     system
!-----------------------------------------------------------------------

!     /*   option of initial geometry file   */
      call read_char_calc &
     &   ( input_style, 10, '<input_style>', 13, iounit )

      if      ( input_style(1:4) .eq. 'OLD ' ) then

!        /*   number of atoms   */
         call read_int1_calc ( natom, '<natom>', 7, iounit )

!        /*   number of species   */
         call read_int1_calc ( nkind, '<nspec>', 7, iounit )

!        /*   number of species   */
         mspec = nkind

!        /*   atomic species   */
         allocate( species(natom) )

!        /*   numbering of species   */
         allocate( ikind(natom) )

      else if ( input_style(1:4) .eq. 'NEW ' ) then

         call testfile ( 'structure.dat', 13, itest, iounit )

         if ( itest .eq. 1 ) then
            write( 6, '(a)' ) 'Error - file missing: structure.dat.'
            write( 6, '(a)' )
            call error_handling_calc &
     &         ( 1, 'subroutine setparams_calc', 25 )
         end if

!        /*   read atoms from structure.dat   */
         call calc_read_init

      else

         write ( 6, '(a)' ) &
     &      'Error - input_style should be either OLD or NEW.'
         write ( 6, '(a)' )

         call error_handling_calc &
     &      ( 1, 'subroutine setparams_calc', 25 )

      end if

!     /*   number of beads:  only even number is valid here.   */
      call read_int1_calc ( nbead, '<nbead>', 7, iounit )

      return
      end





!***********************************************************************
      subroutine calc_read_init
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   natom, nkind, iounit, mspec, species, ikind

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ierr, i, iflag, j

      real(8) :: x, y, z

      character(len=120) :: charline

!-----------------------------------------------------------------------
!     /*   read number of atoms                                       */
!-----------------------------------------------------------------------

!     /*   file open   */
      open ( iounit, file = 'structure.dat' )

!     /*   number of atoms   */
      read ( iounit, *, iostat=ierr ) natom

!     /*   file close   */
      close( iounit )

!-----------------------------------------------------------------------
!     /*   stop on error                                              */
!-----------------------------------------------------------------------

!     /*   if error found   */
      if ( ierr .ne. 0 ) then

!        /*   print comments   */
         write( 6, '(a)' ) &
     &      'Error - structure.dat read incorrectly.'
         write( 6, '(a)' )

!     /*   if error found   */
      end if

!     /*   stop on error   */
      call error_handling_calc( ierr, 'subroutine calc_read_init', 25 )

!-----------------------------------------------------------------------
!     /*   memory allocation                                          */
!-----------------------------------------------------------------------

!     /*   atomic species   */
      allocate( species(natom) )

!     /*   numbering of species   */
      allocate( ikind(natom) )

!-----------------------------------------------------------------------
!     /*   read atomic species                                        */
!-----------------------------------------------------------------------

!     /*   file open   */
      open ( iounit, file = 'structure.dat' )

!     /*   skip two lines   */
      read ( iounit, *, iostat=ierr )
      read ( iounit, *, iostat=ierr )

!     /*   read species   */

      do i = 1, natom
         read ( iounit, '(a)', iostat=ierr ) charline
         read ( charline, *, iostat=ierr ) species(i), x, y, z, ikind(i)
         if ( ierr .ne. 0 ) then
            read ( charline, *, iostat=ierr ) species(i), x, y, z
            if ( ierr .ne. 0 ) exit
            ikind(i) = 1
         end if
      end do

!     /*   file close   */
      close( iounit )

!-----------------------------------------------------------------------
!     /*   stop on error                                              */
!-----------------------------------------------------------------------

!     /*   if error found   */
      if ( ierr .ne. 0 ) then

!        /*   print comments   */
         write( 6, '(a)' ) &
     &      'Error - structure.dat read incorrectly.'
         write( 6, '(a)' )

!     /*   if error found   */
      end if

!     /*   stop on error   */
      call error_handling_calc( ierr, 'subroutine calc_read_init', 25 )

!-----------------------------------------------------------------------
!     /*   nkind: total number of kinds                               */
!-----------------------------------------------------------------------

      nkind = 0

      do i = 1, natom
         nkind = max( nkind, ikind(i) )
      end do

!-----------------------------------------------------------------------
!     /*   mspec: total number of species                             */
!-----------------------------------------------------------------------

      mspec = 1

      do i = 2, natom

         iflag = 1

         do j = 1, i-1

            if ( species(j)(1:8) .eq. species(i)(1:8) ) then

               iflag = 0

               exit

            end if

         end do

         mspec = mspec + iflag

      end do

      return
      end

