!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     set up simulation conditions in post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setcondition_calc
!***********************************************************************
!=======================================================================
!
!     set up conditions
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   ncalc, iounit, mbox, &
     &   iconf_ini_calc, iconf_fin_calc, iprint_calc, iprint_std_calc

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   species                                                    */
!-----------------------------------------------------------------------

      call calc_read_species

!-----------------------------------------------------------------------
!     /*   boundary condition                                         */
!-----------------------------------------------------------------------

      call boundary_calc

!-----------------------------------------------------------------------
!     /*   number of calcs                                            */
!-----------------------------------------------------------------------

      call read_int1_calc ( ncalc, '<ncalc>', 7, iounit )

!-----------------------------------------------------------------------
!     /*   initial conf number                                        */
!-----------------------------------------------------------------------

      call read_int1_calc &
     &   ( iconf_ini_calc, '<iconf_ini_calc>', 16, iounit )

!-----------------------------------------------------------------------
!     /*   final conf number                                          */
!-----------------------------------------------------------------------

      call read_int1_calc &
     &   ( iconf_fin_calc, '<iconf_fin_calc>', 16, iounit )

      if ( iconf_fin_calc .le. 0 ) iconf_fin_calc = -1

!-----------------------------------------------------------------------
!     /*   print interval                                             */
!-----------------------------------------------------------------------

      call read_int1_calc ( iprint_calc, '<iprint_calc>', 13, iounit )

!-----------------------------------------------------------------------
!     /*   standard output                                            */
!-----------------------------------------------------------------------

      call read_int1_calc &
     &   ( iprint_std_calc, '<iprint_std_calc>', 17, iounit )

!-----------------------------------------------------------------------
!     /*   initialize mbox                                            */
!-----------------------------------------------------------------------

      mbox(:,:,:) = 0

      return
      end

