!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     memory allocation
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setallocation_calc
!***********************************************************************
!=======================================================================
!
!     memory allocation
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   x, y, z, vx, vy, vz, fx, fy, fz, pot, ux, uy, uz, physmass, &
     &   physmass_spec, pux, puy, puz, spec, natom_spec, natom, nbead, &
     &   num_spec, int_spec, mbox, mspec, natom_kind, nkind

      implicit none

!-----------------------------------------------------------------------
!     /*   memory allocation                                          */
!-----------------------------------------------------------------------

!     /*   atomic positions   */

      allocate( x(natom,nbead) )
      allocate( y(natom,nbead) )
      allocate( z(natom,nbead) )

!     /*   atomic velocities   */

      allocate( vx(natom,nbead) )
      allocate( vy(natom,nbead) )
      allocate( vz(natom,nbead) )

!     /*   atomic forces   */

      allocate( fx(natom,nbead) )
      allocate( fy(natom,nbead) )
      allocate( fz(natom,nbead) )

!     /*   atomic potentials   */

      allocate( pot(nbead) )

!     /*   atomic masses   */

      allocate( physmass(natom) )

!     /*   normal mode positions    */

      allocate( ux(natom,nbead) )
      allocate( uy(natom,nbead) )
      allocate( uz(natom,nbead) )

!     /*   normal mode momenta      */

      allocate( pux(natom,nbead) )
      allocate( puy(natom,nbead) )
      allocate( puz(natom,nbead) )

!     /*   species   */

      allocate ( natom_spec(mspec) )
      allocate ( physmass_spec(mspec) )
      allocate ( spec(mspec) )
      allocate ( num_spec(mspec) )
      allocate ( int_spec(natom) )

!     /*   kinds   */

      allocate ( natom_kind(nkind) )

!     /*   lattice vectors to unfold the trajectory   */

      allocate( mbox(3,natom,nbead) )

      return
      end

