!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     memory allocation
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine setallocation
!***********************************************************************
!=======================================================================
!
!     memory allocation
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, xs, ys, zs, xnew, ynew, znew, xold, yold, zold, &
     &   xg, yg, zg, vx, vy, vz, fx, fy, fz, pot, physmass, &
     &   ux, uy, uz, vux, vuy, vuz, pux, puy, puz, fux, fuy, fuz, &
     &   fux_ref, fuy_ref, fuz_ref, u, uinv, tnm, tnminv, vir_bead, &
     &   dnmmass, fictmass, xbath, ybath, zbath, rbath_cent, &
     &   xbath_cent, ybath_cent, zbath_cent, vbath_cent, &
     &   vxbath, vybath, vzbath, vxbath_cent, vybath_cent, vzbath_cent, &
     &   fxbath, fybath, fzbath, fxbath_cent, fybath_cent, fzbath_cent, &
     &   fbath_cent, qmass, qmass_cent, ysweight, dipx, dipy, dipz, &
     &   q_es, rbath_box, xbath_box, ybath_box, zbath_box, qmass_box, &
     &   vbath_box, vxbath_box, vybath_box, vzbath_box, &
     &   fbath_box, fxbath_box, fybath_box, fzbath_box, &
     &   physmass_spec, spec, natom_spec, num_spec, &
     &   natom, nbead, nys, nnhc, ncolor, int_spec, mbox, mspec, &
     &   natom_kind, nkind, atom_change, char_spec

      implicit none

!-----------------------------------------------------------------------
!     /*   memory allocation                                          */
!-----------------------------------------------------------------------

!     /*   atomic positions   */

      if ( .not. allocated( x ) ) &
     &   allocate( x(natom,nbead) )
      if ( .not. allocated( y ) ) &
     &   allocate( y(natom,nbead) )
      if ( .not. allocated( z ) ) &
     &   allocate( z(natom,nbead) )

!     /*   atomic positions for ab initio calculation   */

      if ( .not. allocated( xs ) ) &
     &   allocate( xs(natom,nbead) )
      if ( .not. allocated( ys ) ) &
     &   allocate( ys(natom,nbead) )
      if ( .not. allocated( zs ) ) &
     &   allocate( zs(natom,nbead) )

!     /*   atomic positions for geometry optimization   */

      if ( .not. allocated( xnew ) ) &
     &   allocate ( xnew(natom) )
      if ( .not. allocated( ynew ) ) &
     &   allocate ( ynew(natom) )
      if ( .not. allocated( znew ) ) &
     &   allocate ( znew(natom) )
      if ( .not. allocated( xold ) ) &
     &   allocate ( xold(natom) )
      if ( .not. allocated( yold ) ) &
     &   allocate ( yold(natom) )
      if ( .not. allocated( zold ) ) &
     &   allocate ( zold(natom) )

!     /*   center of masses for normal modes   */

      if ( .not. allocated( xg ) ) &
     &   allocate( xg(nbead) )
      if ( .not. allocated( yg ) ) &
     &   allocate( yg(nbead) )
      if ( .not. allocated( zg ) ) &
     &   allocate( zg(nbead) )

!     /*   atomic velocities   */

      if ( .not. allocated( vx ) ) &
     &   allocate( vx(natom,nbead) )
      if ( .not. allocated( vy ) ) &
     &   allocate( vy(natom,nbead) )
      if ( .not. allocated( vz ) ) &
     &   allocate( vz(natom,nbead) )

!     /*   atomic forces   */

      if ( .not. allocated( fx ) ) &
     &   allocate( fx(natom,nbead) )
      if ( .not. allocated( fy ) ) &
     &   allocate( fy(natom,nbead) )
      if ( .not. allocated( fz ) ) &
     &   allocate( fz(natom,nbead) )

!     /*   atomic potentials   */

      if ( .not. allocated( pot ) ) &
     &   allocate( pot(nbead) )

!     /*   atomic masses   */

      if ( .not. allocated( physmass ) ) &
     &   allocate( physmass(natom) )

!     /*   normal mode positions    */

      if ( .not. allocated( ux ) ) &
     &   allocate( ux(natom,nbead) )
      if ( .not. allocated( uy ) ) &
     &   allocate( uy(natom,nbead) )
      if ( .not. allocated( uz ) ) &
     &   allocate( uz(natom,nbead) )

!     /*   normal mode velocities   */

      if ( .not. allocated( vux ) ) &
     &   allocate( vux(natom,nbead) )
      if ( .not. allocated( vuy ) ) &
     &   allocate( vuy(natom,nbead) )
      if ( .not. allocated( vuz ) ) &
     &   allocate( vuz(natom,nbead) )

!     /*   normal mode momenta      */

      if ( .not. allocated( pux ) ) &
     &   allocate( pux(natom,nbead) )
      if ( .not. allocated( puy ) ) &
     &   allocate( puy(natom,nbead) )
      if ( .not. allocated( puz ) ) &
     &   allocate( puz(natom,nbead) )

!     /*   normal mode forces   */

      if ( .not. allocated( fux ) ) &
     &   allocate( fux(natom,nbead) )
      if ( .not. allocated( fuy ) ) &
     &   allocate( fuy(natom,nbead) )
      if ( .not. allocated( fuz ) ) &
     &   allocate( fuz(natom,nbead) )

!     /*   virial   */
      if ( .not. allocated( vir_bead ) ) &
     &   allocate( vir_bead(3,3,nbead) )

!     /*   normal mode reference forces   */

      if ( .not. allocated( fux_ref ) ) &
     &   allocate( fux_ref(natom,nbead) )
      if ( .not. allocated( fuy_ref ) ) &
     &   allocate( fuy_ref(natom,nbead) )
      if ( .not. allocated( fuz_ref ) ) &
     &   allocate( fuz_ref(natom,nbead) )

!     /*   normal mode matrices   */

      if ( .not. allocated( u ) ) &
     &   allocate( u(nbead,nbead) )
      if ( .not. allocated( uinv ) ) &
     &   allocate( uinv(nbead,nbead) )
      if ( .not. allocated( tnm ) ) &
     &   allocate( tnm(nbead,nbead) )
      if ( .not. allocated( tnminv ) ) &
     &   allocate( tnminv(nbead,nbead) )

!     /*   normal mode masses   */

      if ( .not. allocated( dnmmass ) ) &
     &   allocate( dnmmass(natom,nbead) )
      if ( .not. allocated( fictmass ) ) &
     &   allocate( fictmass(natom,nbead) )

!     /*   thermostat positions   */

      if ( .not. allocated( xbath ) ) &
     &   allocate( xbath(natom,nnhc,nbead) )
      if ( .not. allocated( ybath ) ) &
     &   allocate( ybath(natom,nnhc,nbead) )
      if ( .not. allocated( zbath ) ) &
     &   allocate( zbath(natom,nnhc,nbead) )
      if ( .not. allocated( xbath_cent ) ) &
     &   allocate( xbath_cent(natom,nnhc,ncolor) )
      if ( .not. allocated( ybath_cent ) ) &
     &   allocate( ybath_cent(natom,nnhc,ncolor) )
      if ( .not. allocated( zbath_cent ) ) &
     &   allocate( zbath_cent(natom,nnhc,ncolor) )
      if ( .not. allocated( rbath_cent ) ) &
     &   allocate( rbath_cent(nnhc,ncolor) )
      if ( .not. allocated( rbath_box ) ) &
     &   allocate( rbath_box(nnhc,ncolor) )
      if ( .not. allocated( xbath_box ) ) &
     &   allocate( xbath_box(3,nnhc,ncolor) )
      if ( .not. allocated( ybath_box ) ) &
     &   allocate( ybath_box(3,nnhc,ncolor) )
      if ( .not. allocated( zbath_box ) ) &
     &   allocate( zbath_box(3,nnhc,ncolor) )

!     /*   thermostat velocities   */

      if ( .not. allocated( vxbath ) ) &
     &   allocate( vxbath(natom,nnhc,nbead) )
      if ( .not. allocated( vybath ) ) &
     &   allocate( vybath(natom,nnhc,nbead) )
      if ( .not. allocated( vzbath ) ) &
     &   allocate( vzbath(natom,nnhc,nbead) )
      if ( .not. allocated( vxbath_cent ) ) &
     &   allocate( vxbath_cent(natom,nnhc,ncolor) )
      if ( .not. allocated( vybath_cent ) ) &
     &   allocate( vybath_cent(natom,nnhc,ncolor) )
      if ( .not. allocated( vzbath_cent ) ) &
     &   allocate( vzbath_cent(natom,nnhc,ncolor) )
      if ( .not. allocated( vbath_cent ) ) &
     &   allocate( vbath_cent(nnhc,ncolor) )
      if ( .not. allocated( vbath_box ) ) &
     &   allocate( vbath_box(nnhc,ncolor) )
      if ( .not. allocated( vxbath_box ) ) &
     &   allocate( vxbath_box(3,nnhc,ncolor) )
      if ( .not. allocated( vybath_box ) ) &
     &   allocate( vybath_box(3,nnhc,ncolor) )
      if ( .not. allocated( vzbath_box ) ) &
     &   allocate( vzbath_box(3,nnhc,ncolor) )

!     /*   thermostat forces   */

      if ( .not. allocated( fxbath ) ) &
     &   allocate( fxbath(natom,nnhc,nbead) )
      if ( .not. allocated( fybath ) ) &
     &   allocate( fybath(natom,nnhc,nbead) )
      if ( .not. allocated( fzbath ) ) &
     &   allocate( fzbath(natom,nnhc,nbead) )
      if ( .not. allocated( fxbath_cent ) ) &
     &   allocate( fxbath_cent(natom,nnhc,ncolor) )
      if ( .not. allocated( fybath_cent ) ) &
     &   allocate( fybath_cent(natom,nnhc,ncolor) )
      if ( .not. allocated( fzbath_cent ) ) &
     &   allocate( fzbath_cent(natom,nnhc,ncolor) )
      if ( .not. allocated( fbath_cent ) ) &
     &   allocate( fbath_cent(nnhc,ncolor) )
      if ( .not. allocated( fbath_box ) ) &
     &   allocate( fbath_box(nnhc,ncolor) )
      if ( .not. allocated( fxbath_box ) ) &
     &   allocate( fxbath_box(3,nnhc,ncolor) )
      if ( .not. allocated( fybath_box ) ) &
     &   allocate( fybath_box(3,nnhc,ncolor) )
      if ( .not. allocated( fzbath_box ) ) &
     &   allocate( fzbath_box(3,nnhc,ncolor) )

!     /*   thermostat masses   */

      if ( .not. allocated( qmass ) ) &
     &   allocate( qmass(nbead) )
      if ( .not. allocated( qmass_cent ) ) &
     &   allocate( qmass_cent(nnhc,ncolor) )
      if ( .not. allocated( qmass_box ) ) &
     &   allocate( qmass_box(nnhc,ncolor) )

!     /*   Suzuki-Yoshida parameters   */

      if ( .not. allocated( ysweight ) ) &
     &   allocate( ysweight(nys) )

!     /*   species   */

      if ( .not. allocated( natom_spec ) ) &
     &   allocate ( natom_spec(mspec) )
      if ( .not. allocated( physmass_spec ) ) &
     &   allocate ( physmass_spec(mspec) )
      if ( .not. allocated( spec ) ) &
     &   allocate ( spec(mspec) )
      if ( .not. allocated( num_spec ) ) &
     &   allocate ( num_spec(mspec) )
      if ( .not. allocated( int_spec ) ) &
     &   allocate ( int_spec(natom) )
      if ( .not. allocated( char_spec ) ) &
     &   allocate ( char_spec(natom) )

!     /*   kinds   */

      if ( .not. allocated( natom_kind ) ) &
     &   allocate ( natom_kind(nkind) )

!     /*   atomic charges from electronic structure */

      if ( .not. allocated(q_es)) &
     &   allocate ( q_es (2,natom, nbead) )

!     /*   dipole moment   */

      if ( .not. allocated( dipx ) ) &
     &   allocate ( dipx(nbead) )
      if ( .not. allocated( dipy ) ) &
     &   allocate ( dipy(nbead) )
      if ( .not. allocated( dipz ) ) &
     &   allocate ( dipz(nbead) )

!     /*   lattice vectors to unfold the trajectory   */
      if ( .not. allocated( mbox ) ) &
     &   allocate( mbox(3,natom,nbead) )

!     /*   atom change   */
      if ( .not. allocated( atom_change ) ) &
     &   allocate( atom_change(natom) )

      return
      end

