!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jun 2, 2024 by M. Shiga
!      Description:     number of degrees of freedom
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine set_dof
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   gkt, gnkt, gnpkt, beta, irot_start, itrans_start, natom, &
     &   nbead, ndof

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: nrot = 0

!-----------------------------------------------------------------------
!     /*   rotational degrees of freedom                              */
!-----------------------------------------------------------------------

      if      ( natom .eq. 1 ) then
         nrot = 0
      else if ( natom .eq. 2 ) then
         nrot = 2
      else
         nrot = 3
      end if

!-----------------------------------------------------------------------
!     /*   thermal energy per degree of freedom                       */
!-----------------------------------------------------------------------

      gkt = 1.d0/beta

!-----------------------------------------------------------------------
!     /*   values without constraints                                 */
!-----------------------------------------------------------------------

!     //   thermal energy of the physical system
      gnkt  = dble(3*natom)*gkt

!     //   degrees of freedom of the replicated system
      ndof  = 3*natom*nbead

!-----------------------------------------------------------------------
!     /*   shifts by translational constraints                        */
!-----------------------------------------------------------------------

      if      ( itrans_start .eq. 0 ) then
         continue
      else if ( itrans_start .eq. 1 ) then
         gnkt  = gnkt - dble(3)*gkt
         ndof  = ndof - 3
      else if ( itrans_start .eq. 2 ) then
         gnkt  = gnkt - dble(3)*gkt
         ndof  = ndof - 3
      else if ( itrans_start .eq. 3 ) then
         gnkt  = gnkt - dble(3)*gkt
         ndof  = ndof - 3*2
      else if ( itrans_start .eq. 4 ) then
         gnkt  = gnkt - dble(3)*gkt
         ndof  = ndof - 3*2
      else if ( itrans_start .eq. 5 ) then
         gnkt  = gnkt - dble(3)*gkt
         ndof  = ndof - 3*nbead
      else if ( itrans_start .eq. 6 ) then
         gnkt  = gnkt - dble(3)*gkt
         ndof  = ndof - 3*nbead
      end if

!-----------------------------------------------------------------------
!     /*   shifts by rotational constraints                           */
!-----------------------------------------------------------------------

      if      ( irot_start .eq. 0 ) then
         continue
      else if ( irot_start .eq. 1 ) then
         gnkt  = gnkt - dble(nrot)*gkt
         ndof  = ndof - nrot
      else if ( irot_start .eq. 2 ) then
         gnkt  = gnkt - dble(nrot)*gkt
         ndof  = ndof - nrot
      else if ( irot_start .eq. 3 ) then
         gnkt  = gnkt - dble(nrot)*gkt
         ndof  = ndof - nrot*2
      else if ( irot_start .eq. 4 ) then
         gnkt  = gnkt - dble(nrot)*gkt
         ndof  = ndof - nrot*2
      else if ( irot_start .eq. 5 ) then
         gnkt  = gnkt - dble(nrot)*gkt
         ndof  = ndof - nrot*nbead
      else if ( irot_start .eq. 6 ) then
         gnkt  = gnkt - dble(nrot)*gkt
         ndof  = ndof - nrot*nbead
      end if

!-----------------------------------------------------------------------
!     /*   thermal energy of the replicated system                    */
!-----------------------------------------------------------------------

      gnpkt = dble(ndof)/beta

      return
      end
