!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     look for a tag
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine search_tag ( char_tag, length_tag, iounit, ierr )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: k, length_tag, iounit, ierr

      character(len=80) :: char_line

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   do loop start                                              */
!-----------------------------------------------------------------------

      do

!-----------------------------------------------------------------------
!        /*   read a line                                             */
!-----------------------------------------------------------------------

!         read (iounit,'(a80)',iostat=ierr) char_line
         read (iounit,*,iostat=ierr) char_line

!-----------------------------------------------------------------------
!        /*   return if error is found                                */
!-----------------------------------------------------------------------

         if ( ierr .ne. 0 ) return

!-----------------------------------------------------------------------
!        /*   search for the tag                                      */
!-----------------------------------------------------------------------

         k = index(char_line(1:length_tag),char_tag(1:length_tag))

!-----------------------------------------------------------------------
!        /*   return as soon as we find the tag                       */
!-----------------------------------------------------------------------

         if ( k .ge. 1 ) return

!-----------------------------------------------------------------------
!     /*   do loop end                                                */
!-----------------------------------------------------------------------

      end do

      return
      end
