!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     steepest descent dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine sdcycle
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   xnew, ynew, znew, xold, yold, zold, x, y, z, vx, vy, vz, dt, &
     &   istep, istep_start, istep_end, nstep, natom, iexit

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   get interatomic forces   */
      call getforce

!     /*   velocity for sd   */
      call update_vel_sd

!     /*   calculate the hamiltonian and temperature   */
      call standard_sd

!     /*   do some analysis   */
      call analysis ( 1 )

!-----------------------------------------------------------------------
!     /*   start main loop                                            */
!-----------------------------------------------------------------------

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!-----------------------------------------------------------------------
!        /*   step 1                                                  */
!-----------------------------------------------------------------------

         do i = 1, natom
            xold(i) = x(i,1)
            yold(i) = y(i,1)
            zold(i) = z(i,1)
            xnew(i) = x(i,1)
            ynew(i) = y(i,1)
            znew(i) = z(i,1)
         end do

         do i = 1, natom
            xnew(i) = xnew(i) + vx(i,1)*dt*(1.d0/6.d0)
            ynew(i) = ynew(i) + vy(i,1)*dt*(1.d0/6.d0)
            znew(i) = znew(i) + vz(i,1)*dt*(1.d0/6.d0)
         end do

!-----------------------------------------------------------------------
!        /*   step 2                                                  */
!-----------------------------------------------------------------------

         do i = 1, natom
            x(i,1) = xold(i) + vx(i,1)*dt/2.d0
            y(i,1) = yold(i) + vy(i,1)*dt/2.d0
            z(i,1) = zold(i) + vz(i,1)*dt/2.d0
         end do

!        /*   get interatomic forces   */
         call getforce

!        /*   velocity for sd   */
         call update_vel_sd

         do i = 1, natom
            xnew(i) = xnew(i) + vx(i,1)*dt*(2.d0/6.d0)
            ynew(i) = ynew(i) + vy(i,1)*dt*(2.d0/6.d0)
            znew(i) = znew(i) + vz(i,1)*dt*(2.d0/6.d0)
         end do

!-----------------------------------------------------------------------
!        /*   step 3                                                  */
!-----------------------------------------------------------------------

         do i = 1, natom
            x(i,1) = xold(i) + vx(i,1)*dt/2.d0
            y(i,1) = yold(i) + vy(i,1)*dt/2.d0
            z(i,1) = zold(i) + vz(i,1)*dt/2.d0
         end do

!        /*   get interatomic forces   */
         call getforce

!        /*   velocity for sd   */
         call update_vel_sd

         do i = 1, natom
            xnew(i) = xnew(i) + vx(i,1)*dt*(2.d0/6.d0)
            ynew(i) = ynew(i) + vy(i,1)*dt*(2.d0/6.d0)
            znew(i) = znew(i) + vz(i,1)*dt*(2.d0/6.d0)
         end do

!-----------------------------------------------------------------------
!        /*   step 4                                                  */
!-----------------------------------------------------------------------

         do i = 1, natom
            x(i,1) = xold(i) + vx(i,1)*dt
            y(i,1) = yold(i) + vy(i,1)*dt
            z(i,1) = zold(i) + vz(i,1)*dt
         end do

!        /*   get interatomic forces   */
         call getforce

!        /*   velocity for sd   */
         call update_vel_sd

         do i = 1, natom
            xnew(i) = xnew(i) + vx(i,1)*dt*(1.d0/6.d0)
            ynew(i) = ynew(i) + vy(i,1)*dt*(1.d0/6.d0)
            znew(i) = znew(i) + vz(i,1)*dt*(1.d0/6.d0)
         end do

         do i = 1, natom
            x(i,1) = xnew(i)
            y(i,1) = ynew(i)
            z(i,1) = znew(i)
         end do

!        /*   get interatomic forces   */
         call getforce

!        /*   velocity for sd   */
         call update_vel_sd

!-----------------------------------------------------------------------
!        /*   analysis                                                */
!-----------------------------------------------------------------------

!        /*   calculate the hamiltonian and temperature   */
         call standard_sd

!        /*   do some analysis   */
         call analysis ( 2 )

!        /*   output restart   */
         call backup_geoopt

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

!-----------------------------------------------------------------------
!     /*   end of main loop                                           */
!-----------------------------------------------------------------------

      end do

!     /*   current step   */
      istep = istep_end

      return
      end
