!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     save in path integral hybrid Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine save_second_hmc_nvt
!***********************************************************************
!=======================================================================
!
!     save data before trial move
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

!     /*   shared variables   */
      use common_variables, only : &
     &   ux, uy, uz, vux, vuy, vuz, fux, fuy, fuz, pot, potential, &
     &   fux_ref, fuy_ref, fuz_ref, ekin, hamiltonian, qkin, mbox, &
     &   ipotential

!     /*   shared variables   */
      use hmc_variables, only : &
     &   ux_save, uy_save, uz_save, vux_save, vuy_save, vuz_save, &
     &   fux_save, fuy_save, fuz_save, fux_ref_save, fuy_ref_save, &
     &   fuz_ref_save, pot_save, pot_hmc_save, potential_save, &
     &   potential_hmc_save, potential_second_save, ekin_save, &
     &   qkin_save, hamiltonian_save, hamiltonian_hmc_save, pot_hmc, &
     &   pot_second, potential_hmc, potential_second, hamiltonian_hmc, &
     &   pot_second_save, mbox_save

!     /*   shared variables   */
      use dual_variables, only : &
     &   potential_high, potential_low, potential_high_save, &
     &   potential_low_save

!     /*   local variables   */
      implicit none

!-----------------------------------------------------------------------
!     /*   save data                                                  */
!-----------------------------------------------------------------------

      ux_save(:,:)          = ux(:,:)
      uy_save(:,:)          = uy(:,:)
      uz_save(:,:)          = uz(:,:)

      vux_save(:,:)         = vux(:,:)
      vuy_save(:,:)         = vuy(:,:)
      vuz_save(:,:)         = vuz(:,:)

      fux_save(:,:)         = fux(:,:)
      fuy_save(:,:)         = fuy(:,:)
      fuz_save(:,:)         = fuz(:,:)

      fux_ref_save(:,:)     = fux_ref(:,:)
      fuy_ref_save(:,:)     = fuy_ref(:,:)
      fuz_ref_save(:,:)     = fuz_ref(:,:)

      pot_save(:)           = pot(:)
      pot_hmc_save(:)       = pot_hmc(:)
      pot_second_save(:)    = pot_second(:)

      potential_save        = potential
      potential_hmc_save    = potential_hmc
      potential_second_save = potential_second

      ekin_save             = ekin
      qkin_save             = qkin

      hamiltonian_save      = hamiltonian
      hamiltonian_hmc_save  = hamiltonian_hmc

      mbox_save(:,:,:)      = mbox(:,:,:)

      if ( ipotential(1:5) .eq. 'DUAL ' ) then
         potential_high_save = potential_high
         potential_low_save  = potential_low
      end if

      return
      end





!***********************************************************************
      subroutine save_second_hmc_npt
!***********************************************************************
!=======================================================================
!
!     save data before trial move
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

!     /*   shared variables   */
      use common_variables, only : &
     &   ux, uy, uz, vux, vuy, vuz, fux, fuy, fuz, pot, potential, &
     &   fux_ref, fuy_ref, fuz_ref, ekin, hamiltonian, qkin, &
     &   vvol, vlog, vbox, box, vir, pres, pres_iso, mbox, &
     &   ipotential

!     /*   shared variables   */
      use hmc_variables, only : &
     &   ux_save, uy_save, uz_save, vux_save, vuy_save, vuz_save, &
     &   fux_save, fuy_save, fuz_save, fux_ref_save, fuy_ref_save, &
     &   fuz_ref_save, pot_save, pot_hmc_save, potential_save, &
     &   potential_hmc_save, potential_second_save, ekin_save, &
     &   qkin_save, hamiltonian_save, hamiltonian_hmc_save, pot_hmc, &
     &   pot_second, potential_hmc, potential_second, hamiltonian_hmc, &
     &   pot_second_save, vvol_save, vlog_save, vbox_save, box_save, &
     &   vir_save, pres_save, pres_iso_save, mbox_save

!     /*   shared variables   */
      use dual_variables, only : &
     &   potential_high, potential_low, potential_high_save, &
     &   potential_low_save

!     /*   local variables   */
      implicit none

!-----------------------------------------------------------------------
!     /*   save data                                                  */
!-----------------------------------------------------------------------

      ux_save(:,:)          = ux(:,:)
      uy_save(:,:)          = uy(:,:)
      uz_save(:,:)          = uz(:,:)

      vux_save(:,:)         = vux(:,:)
      vuy_save(:,:)         = vuy(:,:)
      vuz_save(:,:)         = vuz(:,:)

      fux_save(:,:)         = fux(:,:)
      fuy_save(:,:)         = fuy(:,:)
      fuz_save(:,:)         = fuz(:,:)

      fux_ref_save(:,:)     = fux_ref(:,:)
      fuy_ref_save(:,:)     = fuy_ref(:,:)
      fuz_ref_save(:,:)     = fuz_ref(:,:)

      pot_save(:)           = pot(:)
      pot_hmc_save(:)       = pot_hmc(:)
      pot_second_save(:)    = pot_second(:)

      potential_save        = potential
      potential_hmc_save    = potential_hmc
      potential_second_save = potential_second

      ekin_save             = ekin
      qkin_save             = qkin

      hamiltonian_save      = hamiltonian
      hamiltonian_hmc_save  = hamiltonian_hmc

      vvol_save             = vvol
      vlog_save             = vlog
      vbox_save(:,:)        = vbox(:,:)

      box_save(:,:)         = box(:,:)

      vir_save(:,:)         = vir(:,:)

      pres_save(:,:)        = pres(:,:)
      pres_iso_save         = pres_iso

      mbox_save(:,:,:)      = mbox(:,:,:)

      if ( ipotential(1:5) .eq. 'DUAL ' ) then
         potential_high_save = potential_high
         potential_low_save  = potential_low
      end if

      return
      end





!***********************************************************************
      subroutine save_second_hmc_ntt
!***********************************************************************
!=======================================================================
!
!     save data before trial move
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

!     /*   shared variables   */
      use common_variables, only : &
     &   ux, uy, uz, vux, vuy, vuz, fux, fuy, fuz, pot, potential, &
     &   fux_ref, fuy_ref, fuz_ref, ekin, hamiltonian, qkin, vvol, &
     &   vlog, vbox, box, vir, pres, pres_iso, strain, stress, mbox, &
     &   ipotential

!     /*   shared variables   */
      use hmc_variables, only : &
     &   ux_save, uy_save, uz_save, vux_save, vuy_save, vuz_save, &
     &   fux_save, fuy_save, fuz_save, fux_ref_save, fuy_ref_save, &
     &   fuz_ref_save, pot_save, pot_hmc_save, potential_save, &
     &   potential_hmc_save, potential_second_save, ekin_save, &
     &   qkin_save, hamiltonian_save, hamiltonian_hmc_save, pot_hmc, &
     &   pot_second, potential_hmc, potential_second, hamiltonian_hmc, &
     &   pot_second_save, vvol_save, vlog_save, vbox_save, box_save, &
     &   vir_save, pres_save, pres_iso_save, strain_save, stress_save, &
     &   mbox_save

!     /*   shared variables   */
      use dual_variables, only : &
     &   potential_high, potential_low, potential_high_save, &
     &   potential_low_save

!     /*   local variables   */
      implicit none

!-----------------------------------------------------------------------
!     /*   save data                                                  */
!-----------------------------------------------------------------------

      ux_save(:,:)          = ux(:,:)
      uy_save(:,:)          = uy(:,:)
      uz_save(:,:)          = uz(:,:)

      vux_save(:,:)         = vux(:,:)
      vuy_save(:,:)         = vuy(:,:)
      vuz_save(:,:)         = vuz(:,:)

      fux_save(:,:)         = fux(:,:)
      fuy_save(:,:)         = fuy(:,:)
      fuz_save(:,:)         = fuz(:,:)

      fux_ref_save(:,:)     = fux_ref(:,:)
      fuy_ref_save(:,:)     = fuy_ref(:,:)
      fuz_ref_save(:,:)     = fuz_ref(:,:)

      pot_save(:)           = pot(:)
      pot_hmc_save(:)       = pot_hmc(:)
      pot_second_save(:)    = pot_second(:)

      potential_save        = potential
      potential_hmc_save    = potential_hmc
      potential_second_save = potential_second

      ekin_save             = ekin
      qkin_save             = qkin

      hamiltonian_save      = hamiltonian
      hamiltonian_hmc_save  = hamiltonian_hmc

      vvol_save             = vvol
      vlog_save             = vlog
      vbox_save(:,:)        = vbox(:,:)

      box_save(:,:)         = box(:,:)

      vir_save(:,:)         = vir(:,:)

      pres_save(:,:)        = pres(:,:)
      pres_iso_save         = pres_iso

      strain_save(:,:)      = strain(:,:)
      stress_save(:,:)      = stress(:,:)

      mbox_save(:,:,:)      = mbox(:,:,:)

      if ( ipotential(1:5) .eq. 'DUAL ' ) then
         potential_high_save = potential_high
         potential_low_save  = potential_low
      end if

      return
      end

