!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 24, 2022 by M. Shiga
!      Description:     save in replica exchange hybrid Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine save_rehmc
!***********************************************************************
!=======================================================================
!
!     save data before trial move
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, ux, uy, uz, vx, vy, vz, pot, fx, fy, fz, natom, nbead, &
     &   mbox

      use rehmc_variables, only : &
     &   pot_save, x_save, y_save, z_save, ux_save, uy_save, uz_save, &
     &   vx_save, vy_save, vz_save, fx_save, fy_save, fz_save, &
     &   hamiltonian_bead_save, hamiltonian_bead, mbox_save

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   save data                                                  */
!-----------------------------------------------------------------------

      do i = 1, nbead

         pot_save(i)                = pot(i)

         hamiltonian_bead_save(i)   = hamiltonian_bead(i)

         do j = 1, natom

            x_save(j,i)                = x(j,i)
            y_save(j,i)                = y(j,i)
            z_save(j,i)                = z(j,i)

            ux_save(j,i)               = ux(j,i)
            uy_save(j,i)               = uy(j,i)
            uz_save(j,i)               = uz(j,i)

            vx_save(j,i)               = vx(j,i)
            vy_save(j,i)               = vy(j,i)
            vz_save(j,i)               = vz(j,i)

            fx_save(j,i)               = fx(j,i)
            fy_save(j,i)               = fy(j,i)
            fz_save(j,i)               = fz(j,i)

         end do

         mbox_save(:,:,i)              = mbox(:,:,i)

      end do

      return
      end





!***********************************************************************
      subroutine save_rex_rehmc
!***********************************************************************
!=======================================================================
!
!     save data before trial move
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, vx, vy, vz, fx, fy, fz, ux, uy, uz, pot, natom, nbead, &
     &   mbox

      use rehmc_variables, only : &
     &   x_save, y_save, z_save, ux_save, uy_save, uz_save, &
     &   vx_save, vy_save, vz_save, fx_save, fy_save, fz_save, &
     &   hamiltonian_bead, hamiltonian_bead_save, pot_save, &
     &   fx_alchem_save, fy_alchem_save, fz_alchem_save, &
     &   pot_alchem_save, mbox_save

      use alchem_variables, only : &
     &   fx_alchem, fy_alchem, fz_alchem, pot_alchem

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k

!-----------------------------------------------------------------------
!     /*   save data                                                  */
!-----------------------------------------------------------------------

      do i = 1, nbead

         pot_save(i)                = pot(i)

         hamiltonian_bead_save(i)   = hamiltonian_bead(i)

         do j = 1, natom

            x_save(j,i)                = x(j,i)
            y_save(j,i)                = y(j,i)
            z_save(j,i)                = z(j,i)

            ux_save(j,i)               = ux(j,i)
            uy_save(j,i)               = uy(j,i)
            uz_save(j,i)               = uz(j,i)

            vx_save(j,i)               = vx(j,i)
            vy_save(j,i)               = vy(j,i)
            vz_save(j,i)               = vz(j,i)

            fx_save(j,i)               = fx(j,i)
            fy_save(j,i)               = fy(j,i)
            fz_save(j,i)               = fz(j,i)

         end do

         mbox_save(:,:,i)              = mbox(:,:,i)

         do j = 1, nbead

            pot_alchem_save(j,i)       = pot_alchem(j,i)

            do k = 1, natom

               fx_alchem_save(k,j,i)   = fx_alchem(k,j,i)
               fy_alchem_save(k,j,i)   = fy_alchem(k,j,i)
               fz_alchem_save(k,j,i)   = fz_alchem(k,j,i)

            end do

         end do

      end do

      return
      end





!***********************************************************************
      subroutine save_rehmc_npt
!***********************************************************************
!=======================================================================
!
!     save data before trial move
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, ux, uy, uz, vx, vy, vz, pot, fx, fy, fz, box_bead, &
     &   vbox_bead, vir_bead, boxinv_bead, volume_bead, natom, nbead, &
     &   mbox

      use rehmc_variables, only : &
     &   pot_save, x_save, y_save, z_save, ux_save, uy_save, uz_save, &
     &   vx_save, vy_save, vz_save, fx_save, fy_save, fz_save, &
     &   hamiltonian_bead_save, hamiltonian_bead, box_bead_save, &
     &   boxinv_bead_save, volume_bead_save, vbox_bead_save, &
     &   vir_bead_save, mbox_save

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   save data                                                  */
!-----------------------------------------------------------------------

      do i = 1, nbead

         pot_save(i)                = pot(i)

         hamiltonian_bead_save(i)   = hamiltonian_bead(i)

         do j = 1, natom

            x_save(j,i)                = x(j,i)
            y_save(j,i)                = y(j,i)
            z_save(j,i)                = z(j,i)

            ux_save(j,i)               = ux(j,i)
            uy_save(j,i)               = uy(j,i)
            uz_save(j,i)               = uz(j,i)

            vx_save(j,i)               = vx(j,i)
            vy_save(j,i)               = vy(j,i)
            vz_save(j,i)               = vz(j,i)

            fx_save(j,i)               = fx(j,i)
            fy_save(j,i)               = fy(j,i)
            fz_save(j,i)               = fz(j,i)

         end do

         mbox_save(:,:,i)              = mbox(:,:,i)

         box_bead_save(:,:,:)          = box_bead(:,:,:)
         boxinv_bead_save(:,:,:)       = boxinv_bead(:,:,:)
         volume_bead_save(:)           = volume_bead(:)
         vbox_bead_save(:,:,:)         = vbox_bead(:,:,:)
         vir_bead_save(:,:,:)          = vir_bead(:,:,:)

      end do

      return
      end





!***********************************************************************
      subroutine save_remc
!***********************************************************************
!=======================================================================
!
!     save data before trial move
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, pot, fx, fy, fz, vir_bead, natom, nbead, ipotential

      use rehmc_variables, only : &
     &   pot_save, x_save, y_save, z_save, fx_save, fy_save, fz_save, &
     &   vir_bead_save, pot_low_save

      use dual_variables, only : &
     &   pot_low

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k

!-----------------------------------------------------------------------
!     /*   save data                                                  */
!-----------------------------------------------------------------------

      do i = 1, nbead

         pot_save(i) = pot(i)

         do j = 1, natom

            x_save(j,i) = x(j,i)
            y_save(j,i) = y(j,i)
            z_save(j,i) = z(j,i)

            fx_save(j,i) = fx(j,i)
            fy_save(j,i) = fy(j,i)
            fz_save(j,i) = fz(j,i)

         end do

         do k = 1, 3
         do j = 1, 3
            vir_bead_save(j,k,i) = vir_bead(j,k,i)
         end do
         end do

      end do

!-----------------------------------------------------------------------
!     /*   dual: save data                                            */
!-----------------------------------------------------------------------

      if ( ipotential(1:5) .eq. 'DUAL ' ) then

         do i = 1, nbead
            pot_low_save(i) = pot_low(i)
         end do

      end if

      return
      end
