!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     polymers copy positions
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine save_pos_polymers_atom_MPI( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : ux, uy, uz, natom, iboundary, mbox

      use polymers_variables, only : xc_poly, yc_poly, zc_poly, jpoly

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, ioption

      integer :: m1, m2, m3

      real(8) :: xc, yc, zc

!-----------------------------------------------------------------------
!     /*   ux, uy, uz <- xc_poly, yc_poly, zc_poly                    */
!-----------------------------------------------------------------------

      if ( ioption .eq. 0 ) then

         ux(:,1) = xc_poly(:,jpoly)
         uy(:,1) = yc_poly(:,jpoly)
         uz(:,1) = zc_poly(:,jpoly)

         if ( ( iboundary .eq. 1 ) .or. ( iboundary .eq. 2 ) ) then

            mbox(:,:,:) = 0

         end if

      end if

!-----------------------------------------------------------------------
!     /*   ux, uy, uz <- xc_poly, yc_poly, zc_poly                    */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         if      ( iboundary .eq. 0 ) then

            ux(:,1) = xc_poly(:,jpoly)
            uy(:,1) = yc_poly(:,jpoly)
            uz(:,1) = zc_poly(:,jpoly)

         else if ( iboundary .eq. 1 ) then

!            do i = 1, natom
!
!               xc = ux(i,1) - xc_poly(i,jpoly)
!               yc = uy(i,1) - yc_poly(i,jpoly)
!               zc = uz(i,1) - zc_poly(i,jpoly)
!
!               call pbc_atom_MPI( xc, yc, zc )
!
!               ux(i,1) = xc_poly(i,jpoly) + xc
!               uy(i,1) = yc_poly(i,jpoly) + yc
!               uz(i,1) = zc_poly(i,jpoly) + zc
!
!            end do

            ux(:,1) = xc_poly(:,jpoly)
            uy(:,1) = yc_poly(:,jpoly)
            uz(:,1) = zc_poly(:,jpoly)

            mbox(:,:,:) = 0

         else if ( iboundary .eq. 2 ) then

            ux(:,1) = xc_poly(:,jpoly)
            uy(:,1) = yc_poly(:,jpoly)
            uz(:,1) = zc_poly(:,jpoly)

            mbox(:,:,:) = 0

         end if

      end if

!-----------------------------------------------------------------------
!     /*   ux, uy, uz -> xc_poly, yc_poly, zc_poly                    */
!-----------------------------------------------------------------------

      if ( ioption .eq. 2 ) then

         if      ( iboundary .eq. 0 ) then

            xc_poly(:,jpoly) = ux(:,1)
            yc_poly(:,jpoly) = uy(:,1)
            zc_poly(:,jpoly) = uz(:,1)

         else if ( iboundary .eq. 1 ) then

            do i = 1, natom

               xc = ux(i,1)
               yc = uy(i,1)
               zc = uz(i,1)

               m1 = mbox(1,i,1)
               m2 = mbox(2,i,1)
               m3 = mbox(3,i,1)

               call pbc_unfold_MPI( xc, yc, zc, m1, m2, m3 )

               xc_poly(i,jpoly) = xc
               yc_poly(i,jpoly) = yc
               zc_poly(i,jpoly) = zc

            end do

!            xc_poly(:,jpoly) = ux(:,1)
!            yc_poly(:,jpoly) = uy(:,1)
!            zc_poly(:,jpoly) = uz(:,1)

         else if ( iboundary .eq. 2 ) then

            xc_poly(:,jpoly) = ux(:,1)
            yc_poly(:,jpoly) = uy(:,1)
            zc_poly(:,jpoly) = uz(:,1)

         end if

      end if

      return
      end





!***********************************************************************
      subroutine save_force_polymers_atom_MPI( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : natom

      use polymers_variables, only : &
     &   fxc_poly, fyc_poly, fzc_poly, ekinvir_poly, epot_poly, jpoly, &
     &   npoly

      use analysis_variables, only : &
     &   fux_avg, fuy_avg, fuz_avg, ekinvir_avg, epot_avg

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ioption

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      if ( ( ioption .eq. 0 ) .or. ( ioption .eq. 1 ) ) then

         fxc_poly(:,:)   = 0.d0
         fyc_poly(:,:)   = 0.d0
         fzc_poly(:,:)   = 0.d0

         ekinvir_poly(:) = 0.d0
         epot_poly(:)    = 0.d0

      else if ( ioption .eq. 2 ) then

         fxc_poly(:,jpoly)   = fux_avg(:)
         fyc_poly(:,jpoly)   = fuy_avg(:)
         fzc_poly(:,jpoly)   = fuz_avg(:)

         ekinvir_poly(jpoly) = ekinvir_avg
         epot_poly(jpoly)    = epot_avg

      else if ( ioption .eq. 3 ) then

         call my_mpi_allreduce_real_2_top( fxc_poly, natom, npoly )
         call my_mpi_allreduce_real_2_top( fyc_poly, natom, npoly )
         call my_mpi_allreduce_real_2_top( fzc_poly, natom, npoly )

         call my_mpi_allreduce_real_1_top( ekinvir_poly, npoly )
         call my_mpi_allreduce_real_1_top( epot_poly, npoly )

      end if

      return
      end





!***********************************************************************
      subroutine save_pos_polymers_cons_MPI( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : nbead
      use cons_variables, only : rcons
      use polymers_variables, only : rcons_poly, jpoly

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: j, ioption

!-----------------------------------------------------------------------
!     /*   rcons_poly -> rcons                                        */
!-----------------------------------------------------------------------

      if ( ioption .eq. 0 ) then

         do j = 1, nbead
            rcons(:,j) = rcons_poly(:,jpoly)
         end do

      end if

!-----------------------------------------------------------------------
!     /*   rcons_poly -> rcons                                        */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         do j = 1, nbead
            rcons(:,j) = rcons_poly(:,jpoly)
         end do

      end if

!-----------------------------------------------------------------------
!     /*   rcons -> rcons_poly                                        */
!-----------------------------------------------------------------------

      if ( ioption .eq. 2 ) then

         do j = 1, nbead
            rcons_poly(:,jpoly) = rcons(:,j)
         end do

      end if

      return
      end





!***********************************************************************
      subroutine save_force_polymers_cons_MPI( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use cons_variables, only : &
     &   scons_avg, fref_cons_avg, ncons

      use polymers_variables, only : &
     &   scons_poly, fcons_poly, ekinvir_poly, epot_poly, jpoly, npoly

      use analysis_variables, only : &
     &   ekinvir_avg, epot_avg

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ioption

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      if ( ( ioption .eq. 0 ) .or. ( ioption .eq. 1 ) ) then

         scons_poly(:,:) = 0.d0
         fcons_poly(:,:) = 0.d0
         ekinvir_poly(:) = 0.d0
         epot_poly(:)    = 0.d0

      else if ( ioption .eq. 2 ) then

         scons_poly(:,jpoly) = scons_avg(:,1)
         fcons_poly(:,jpoly) = fref_cons_avg(:,1)
         ekinvir_poly(jpoly) = ekinvir_avg
         epot_poly(jpoly)    = epot_avg

      else if ( ioption .eq. 3 ) then

         call my_mpi_allreduce_real_2_top( scons_poly, ncons, npoly )
         call my_mpi_allreduce_real_2_top( fcons_poly, ncons, npoly )
         call my_mpi_allreduce_real_1_top( ekinvir_poly, npoly )
         call my_mpi_allreduce_real_1_top( epot_poly, npoly )

      end if

      return
      end
