!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jan 23, 2025 by M. Shiga
!      Description:     extensive MPI parallelization
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine rpmdcycle_nve_XMPI
!***********************************************************************
!=======================================================================
!
!     The RPMD molecular dynamics cycle (analytical version).
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   preparation of parallel MPI   */
      call prep_XMPI

!     /*   normal mode position -> Cartesian position   */
      call nm_trans_XMPI( 0 )

!     /*   get interatomic forces   */
      call getforce_XMPI

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force_XMPI( 1 )

!     /*   get harmonic force  */
      call getforce_ref_XMPI

!     /*   calculate the hamiltonian and temperature   */
      call standard_nve_0_XMPI

!     /*   do some analysis   */
      call analysis_XMPI ( 1 )

!     /*   main loop start   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update the velocities by interatomic forces   */
         call update_vel_XMPI

!        /*   update all the normal mode coordinates   */
         call update_posvel_anal_XMPI

!        /*   normal mode position -> Cartesian position   */
         call nm_trans_XMPI( 0 )

!        /*   get interatomic forces   */
         call getforce_XMPI

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force_XMPI( 1 )

!        /*   update the velocities by interatomic forces   */
         call update_vel_XMPI

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity_XMPI( 0 )

!        /*   calculate the hamiltonian and temperature   */
         call standard_nve_0_XMPI

!        /*   do some analysis   */
         call analysis_XMPI ( 2 )

!        /*   output restart   */
         call backup_pimd_nve_XMPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

!     /*   main loop end   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine rpmdcycle_nve_debug_XMPI
!***********************************************************************
!=======================================================================
!
!     The RPMD molecular dynamics cycle (analytical version).
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   preparation of parallel MPI   */
      call my_mpi_wtime(  1 )
      call prep_XMPI
      call my_mpi_wtime(  1 )

!     /*   normal mode position -> Cartesian position   */
      call my_mpi_wtime(  2 )
      call nm_trans_XMPI( 0 )
      call my_mpi_wtime(  2 )

!     /*   get interatomic forces   */
      call getforce_XMPI

!     /*   Cartesian force -> normal mode force   */
      call my_mpi_wtime(  4 )
      call nm_trans_force_XMPI( 1 )
      call my_mpi_wtime(  4 )

!     /*   get harmonic force  */
      call my_mpi_wtime(  5 )
      call getforce_ref_XMPI
      call my_mpi_wtime(  5 )

!     /*   calculate the hamiltonian and temperature   */
      call my_mpi_wtime(  6 )
      call standard_nve_0_XMPI
      call my_mpi_wtime(  6 )

!     /*   do some analysis   */
      call my_mpi_wtime(  7 )
      call analysis_XMPI ( 1 )
      call my_mpi_wtime(  7 )

!     /*   main loop start   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update the velocities by interatomic forces   */
         call my_mpi_wtime(  8 )
         call update_vel_XMPI
         call my_mpi_wtime(  8 )

!        /*   update all the normal mode coordinates   */
         call my_mpi_wtime(  9 )
         call update_posvel_anal_XMPI
         call my_mpi_wtime(  9 )

!        /*   normal mode position -> Cartesian position   */
         call my_mpi_wtime(  2 )
         call nm_trans_XMPI( 0 )
         call my_mpi_wtime(  2 )

!        /*   get interatomic forces   */
         call getforce_XMPI

!        /*   Cartesian force -> normal mode force   */
         call my_mpi_wtime(  4 )
         call nm_trans_force_XMPI( 1 )
         call my_mpi_wtime(  4 )

!        /*   update the velocities by interatomic forces   */
         call my_mpi_wtime(  8 )
         call update_vel_XMPI
         call my_mpi_wtime(  8 )

!        /*   normal mode velocity -> Cartesian velocity   */
         call my_mpi_wtime( 10 )
         call nm_trans_velocity_XMPI( 0 )
         call my_mpi_wtime( 10 )

!        /*   calculate the hamiltonian and temperature   */
         call my_mpi_wtime(  6 )
         call standard_nve_0_XMPI
         call my_mpi_wtime(  6 )

!        /*   do some analysis   */
         call my_mpi_wtime(  7 )
         call analysis_XMPI ( 2 )
         call my_mpi_wtime(  7 )

!        /*   output restart   */
         call my_mpi_wtime( 11 )
         call backup_pimd_nve_XMPI
         call my_mpi_wtime( 11 )

!        /*   exit if `exit.dat' exists   */
         call my_mpi_wtime( 12 )
         call softexit_MPI
         call my_mpi_wtime( 12 )
         if ( iexit .eq. 1 ) exit

!     /*   main loop end   */
      end do

!     /*   current step   */
      istep = istep_end

      call my_mpi_wtime( 0 )

      return
      end
