!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 24, 2022 by M. Shiga
!      Description:     restart replica exchange hybrid Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine restart_rehmc( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, vx, vy, vz, iounit, istep_end, nbead, natom, mbox

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, ioption

!-----------------------------------------------------------------------
!     /*   read geometry                                              */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         open ( iounit, file = 'geometry.ini' )

         do i = 1, nbead
         do j = 1, natom
            read( iounit, * ) &
     &         k, x(j,i), y(j,i), z(j,i), &
     &         vx(j,i), vy(j,i), vz(j,i), mbox(1:3,j,i)
         end do
         end do

         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   write geometry                                             */
!-----------------------------------------------------------------------

      if ( ioption .eq. 2 ) then

         open ( iounit, file = 'geometry.ini' )

         k = istep_end

         do i = 1, nbead
         do j = 1, natom
            write( iounit, '(i8,6e24.16,3i4)' ) &
     &         k, x(j,i), y(j,i), z(j,i), &
     &         vx(j,i), vy(j,i), vz(j,i), mbox(1:3,j,i)
         end do
         end do

         close( iounit )

      end if

      return
      end





!***********************************************************************
      subroutine restart_rehmc_npt( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, vx, vy, vz, iounit, istep_end, nbead, natom, mbox

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, ioption

!-----------------------------------------------------------------------
!     /*   read geometry                                              */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         open ( iounit, file = 'geometry.ini' )

         do i = 1, nbead
         do j = 1, natom
            read( iounit, * ) &
     &         k, x(j,i), y(j,i), z(j,i), &
     &         vx(j,i), vy(j,i), vz(j,i), mbox(1:3,j,i)
         end do
         end do

         close( iounit )

         call restart_box_rehmc( 3 )

      end if

!-----------------------------------------------------------------------
!     /*   write geometry                                             */
!-----------------------------------------------------------------------

      if ( ioption .eq. 2 ) then

         open ( iounit, file = 'geometry.ini' )

         k = istep_end

         do i = 1, nbead
         do j = 1, natom
            write( iounit, '(i8,6e24.16,3i4)' ) &
     &         k, x(j,i), y(j,i), z(j,i), &
     &         vx(j,i), vy(j,i), vz(j,i), mbox(1:3,j,i)
         end do
         end do

         close( iounit )

         call restart_box_rehmc( 4 )

      end if

      return
      end





!***********************************************************************
      subroutine restart_remc( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, iounit, istep_end, nbead, natom, mbox

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, ioption

      real(8) :: zero

!-----------------------------------------------------------------------
!     /*   read geometry                                              */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         open ( iounit, file = 'geometry.ini' )

         do i = 1, nbead
         do j = 1, natom
            read( iounit, * ) &
     &         k, x(j,i), y(j,i), z(j,i), &
     &         zero, zero, zero, mbox(1:3,j,i)
         end do
         end do

         close( iounit )

         call restart_box_rehmc( 1 )

      end if

!-----------------------------------------------------------------------
!     /*   write geometry                                             */
!-----------------------------------------------------------------------

      if ( ioption .eq. 2 ) then

         open ( iounit, file = 'geometry.ini' )

         k = istep_end

         do i = 1, nbead
         do j = 1, natom
            write( iounit, '(i8,6e24.16,3i4)' ) &
     &         k, x(j,i), y(j,i), z(j,i), &
     &         0.d0, 0.d0, 0.d0, mbox(1:3,j,i)
         end do
         end do

         close( iounit )

         call restart_box_rehmc( 2 )

      end if

      return
      end
